/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.planner.actionplanner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.Kernel;
import com.microsoft.semantickernel.SKBuilders;
import com.microsoft.semantickernel.orchestration.ContextVariables;
import com.microsoft.semantickernel.orchestration.SKContext;
import com.microsoft.semantickernel.orchestration.SKFunction;
import com.microsoft.semantickernel.orchestration.WritableContextVariables;
import com.microsoft.semantickernel.planner.PlanningException;
import com.microsoft.semantickernel.planner.actionplanner.ActionPlanResponse;
import com.microsoft.semantickernel.planner.actionplanner.Plan;
import com.microsoft.semantickernel.semanticfunctions.PromptTemplateConfig;
import com.microsoft.semantickernel.skilldefinition.ReadOnlySkillCollection;
import com.microsoft.semantickernel.skilldefinition.annotations.DefineSKFunction;
import com.microsoft.semantickernel.skilldefinition.annotations.SKFunctionParameters;
import com.microsoft.semantickernel.textcompletion.CompletionRequestSettings;
import com.microsoft.semantickernel.textcompletion.CompletionSKFunction;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ActionPlanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionPlanner.class);
    private static final Pattern CLEAN_PLAN = Pattern.compile("[^{]*(\\{.*})[^}]*", 40);
    private static final String StopSequence = "#END-OF-PLAN";
    private static final String SkillName = "this";
    private final CompletionSKFunction plannerFunction;
    private SKContext context;
    private Kernel kernel;

    public ActionPlanner(Kernel kernel, @Nullable String prompt) {
        String promptTemplate = prompt == null ? ActionPlanner.read("skprompt.txt") : prompt;
        this.plannerFunction = (CompletionSKFunction)SKBuilders.completionFunctions().withKernel(kernel).withPromptTemplate(promptTemplate).withSkillName(SkillName).withCompletionConfig(new PromptTemplateConfig.CompletionConfig(0.0, 0.0, 0.0, 0.0, 1024)).build();
        kernel.importSkill((Object)this, SkillName);
        this.kernel = kernel;
        this.context = (SKContext)SKBuilders.context().withSkills(kernel.getSkills()).build();
    }

    public static String read(String file) {
        String string;
        block8: {
            InputStream stream = ActionPlanner.class.getResourceAsStream(file);
            try {
                byte[] buffer = new byte[stream.available()];
                stream.read(buffer);
                string = new String(buffer, StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return string;
    }

    public Mono<Plan> createPlanAsync(String goal) {
        if (goal == null || goal.isEmpty()) {
            throw new PlanningException(PlanningException.ErrorCodes.INVALID_GOAL, "The goal specified is empty");
        }
        this.context = this.context.update(goal);
        return this.plannerFunction.invokeAsync(this.context, (Object)new CompletionRequestSettings(0.0, 0.0, 0.0, 0.0, 2048)).handle((result, sink) -> {
            try {
                sink.next((Object)this.parsePlan(goal, (SKContext)result));
            }
            catch (Exception e) {
                sink.error((Throwable)e);
            }
        });
    }

    private Plan parsePlan(String goal, SKContext result) {
        ActionPlanResponse planData;
        Matcher matcher = CLEAN_PLAN.matcher(result.getResult());
        String plan = result.getResult();
        if (matcher.matches()) {
            plan = matcher.group(1);
        }
        try {
            planData = (ActionPlanResponse)new ObjectMapper().readValue(plan, ActionPlanResponse.class);
        }
        catch (Exception e) {
            throw new PlanningException(PlanningException.ErrorCodes.INVALID_PLAN, "Plan parsing error, invalid JSON", (Throwable)e);
        }
        if (planData == null) {
            throw new PlanningException(PlanningException.ErrorCodes.INVALID_PLAN, "The plan deserialized to a null object");
        }
        SKFunction function = this.getPlanFunction(planData);
        WritableContextVariables variables = ((ContextVariables)SKBuilders.variables().build()).writableClone();
        planData.plan.parameters.entrySet().forEach(entry -> variables.setVariable((String)entry.getKey(), (String)entry.getValue()));
        if (function == null) {
            return new Plan(goal, (ContextVariables)variables, () -> this.kernel.getSkills());
        }
        return new Plan(goal, (ContextVariables)variables, () -> this.kernel.getSkills(), function);
    }

    public SKFunction getPlanFunction(ActionPlanResponse planData) {
        if (planData.plan.function.contains(".")) {
            String[] parts = planData.plan.function.split("\\.", -1);
            SKFunction function = this.context.getSkills().getFunction(parts[0], parts[1], SKFunction.class);
            if (function == null) {
                throw new PlanningException(PlanningException.ErrorCodes.INVALID_PLAN, "Unknown function " + planData.plan.function);
            }
            return function;
        }
        if (!planData.plan.function.isEmpty()) {
            CompletionSKFunction function = (CompletionSKFunction)this.context.getSkills().getFunction(planData.plan.function, CompletionSKFunction.class);
            if (function == null) {
                throw new PlanningException(PlanningException.ErrorCodes.INVALID_PLAN, "Unknown skill " + planData.plan.function);
            }
            return function;
        }
        return null;
    }

    @DefineSKFunction(name="listOfFunctions", description="List all functions available in the kernel")
    @Nullable
    public String listOfFunctions(@SKFunctionParameters(name="goal", description="The current goal processed by the planner", defaultValue="") String goal, SKContext context) {
        ReadOnlySkillCollection skills = context.getSkills();
        return this.populateList(skills);
    }

    @DefineSKFunction(name="GoodExamples", description="List a few good examples of plans to generate")
    public String goodExamples(@SKFunctionParameters(name="goal", description="The current goal processed by the planner", defaultValue="") String goal, SKContext context) {
        return "\n[EXAMPLE]\n- List of functions:\n// Read a file.\nFileIOSkill.ReadAsync\nParameter \"path\": Source file.\n// Write a file.\nFileIOSkill.WriteAsync\nParameter \"path\": Destination file. (default value: sample.txt)\nParameter \"content\": File content.\n// Get the current time.\nTimeSkill.Time\nNo parameters.\n// Makes a POST request to a uri.\nHttpSkill.PostAsync\nParameter \"body\": The body of the request.\n- End list of functions.\nGoal: create a file called \"something.txt\".\n{\"plan\":{\n\"rationale\": \"the list contains a function that allows to create files\",\n\"function\": \"FileIOSkill.WriteAsync\",\n\"parameters\": {\n\"path\": \"something.txt\",\n\"content\": null\n}}}\n#END-OF-PLAN\n";
    }

    @DefineSKFunction(name="EdgeCaseExamples", description="List a few edge case examples of plans to handle")
    public String edgeCaseExamples(@SKFunctionParameters(name="goal", description="The current goal processed by the planner", defaultValue="") String goal, SKContext context) {
        return "\n[EXAMPLE]\n- List of functions:\n// Get the current time.\nTimeSkill.Time\nNo parameters.\n// Write a file.\nFileIOSkill.WriteAsync\nParameter \"path\": Destination file. (default value: sample.txt)\nParameter \"content\": File content.\n// Makes a POST request to a uri.\nHttpSkill.PostAsync\nParameter \"body\": The body of the request.\n// Read a file.\nFileIOSkill.ReadAsync\nParameter \"path\": Source file.\n- End list of functions.\nGoal: tell me a joke.\n{\"plan\":{\n\"rationale\": \"the list does not contain functions to tell jokes or something funny\",\n\"function\": \"\",\n\"parameters\": {\n}}}\n#END-OF-PLAN\n";
    }

    private String populateList(ReadOnlySkillCollection skills) {
        return skills.getAllFunctions().getAll().stream().filter(skill -> !SkillName.equalsIgnoreCase(skill.getSkillName())).map(func -> {
            StringBuilder result = new StringBuilder();
            if (func.getDescription() != null) {
                result.append("// " + ActionPlanner.addPeriod(func.getDescription()) + "\n");
            } else {
                LOGGER.warn("{0}.{1} is missing a description", (Object)func.getSkillName(), (Object)func.getName());
                result.append("// Function " + func.getSkillName() + "." + func.getName() + ".\n");
            }
            result.append(func.getSkillName() + "." + func.getName() + "\n");
            func.describe().getParameters().forEach(parameter -> {
                String description = parameter.getDescription() == null || parameter.getDefaultValue().isEmpty() ? parameter.getName() : parameter.getDescription();
                String defaultValueString = parameter.getDefaultValue() == null || parameter.getDefaultValue().isEmpty() ? "" : " (default value: " + parameter.getDefaultValue() + ")";
                result.append("Parameter \"" + parameter.getName() + "\": " + ActionPlanner.addPeriod(description) + " " + defaultValueString + "\n");
            });
            return result.toString();
        }).reduce("", (a, b) -> a + b, (a, b) -> a + b);
    }

    private static String addPeriod(String x) {
        return x.endsWith(".") ? x : x + ".";
    }
}

