/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.orchestration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.orchestration.responseformat.JsonObjectResponseFormat;
import com.microsoft.semantickernel.orchestration.responseformat.JsonSchemaResponseFormat;
import com.microsoft.semantickernel.orchestration.responseformat.ResponseFormat;
import com.microsoft.semantickernel.orchestration.responseformat.TextResponseFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class PromptExecutionSettings {
    public static final String DEFAULT_SERVICE_ID = "default";
    public static final int DEFAULT_MAX_TOKENS = 256;
    public static final double DEFAULT_TEMPERATURE = 1.0;
    public static final double DEFAULT_TOP_P = 1.0;
    public static final double DEFAULT_PRESENCE_PENALTY = 0.0;
    public static final double DEFAULT_FREQUENCY_PENALTY = 0.0;
    public static final int DEFAULT_BEST_OF = 1;
    public static final int DEFAULT_RESULTS_PER_PROMPT = 1;
    private static final String SERVICE_ID = "service_id";
    private static final String MODEL_ID = "model_id";
    private static final String TEMPERATURE = "temperature";
    private static final String TOP_P = "top_p";
    private static final String PRESENCE_PENALTY = "presence_penalty";
    private static final String FREQUENCY_PENALTY = "frequency_penalty";
    private static final String MAX_TOKENS = "max_tokens";
    private static final String BEST_OF = "best_of";
    private static final String USER = "user";
    private static final String STOP_SEQUENCES = "stop_sequences";
    private static final String RESULTS_PER_PROMPT = "results_per_prompt";
    private static final String TOKEN_SELECTION_BIASES = "token_selection_biases";
    private static final String RESPONSE_FORMAT = "response_format";
    private final String serviceId;
    private final String modelId;
    private final double temperature;
    private final double topP;
    private final double presencePenalty;
    private final double frequencyPenalty;
    private final int maxTokens;
    private final int bestOf;
    private final int resultsPerPrompt;
    private final String user;
    private final List<String> stopSequences;
    private final Map<Integer, Integer> tokenSelectionBiases;
    private final ResponseFormat responseFormat;

    @JsonCreator
    public PromptExecutionSettings(@JsonProperty(value="service_id") String serviceId, @JsonProperty(value="model_id") String modelId, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="top_p") Double topP, @JsonProperty(value="presence_penalty") Double presencePenalty, @JsonProperty(value="frequency_penalty") Double frequencyPenalty, @JsonProperty(value="max_tokens") Integer maxTokens, @JsonProperty(value="results_per_prompt") Integer resultsPerPrompt, @JsonProperty(value="best_of") Integer bestOf, @JsonProperty(value="user") String user, @Nullable @JsonProperty(value="stop_sequences") List<String> stopSequences, @Nullable @JsonProperty(value="token_selection_biases") Map<Integer, Integer> tokenSelectionBiases, @Nullable @JsonProperty(value="response_format") ResponseFormat responseFormat) {
        this.serviceId = serviceId != null ? serviceId : DEFAULT_SERVICE_ID;
        this.modelId = modelId != null ? modelId : "";
        this.temperature = PromptExecutionSettings.clamp(temperature, 0.0, 2.0, 1.0);
        this.topP = PromptExecutionSettings.clamp(topP, 0.0, 1.0, 1.0);
        this.presencePenalty = PromptExecutionSettings.clamp(presencePenalty, -2.0, 2.0, 0.0);
        this.frequencyPenalty = PromptExecutionSettings.clamp(frequencyPenalty, -2.0, 2.0, 0.0);
        this.maxTokens = PromptExecutionSettings.clamp(maxTokens, 1, Integer.MAX_VALUE, 256);
        this.resultsPerPrompt = PromptExecutionSettings.clamp(resultsPerPrompt, 1, Integer.MAX_VALUE, 1);
        this.bestOf = PromptExecutionSettings.clamp(bestOf, 1, Integer.MAX_VALUE, 1);
        this.user = user != null ? user : "";
        this.stopSequences = stopSequences != null ? new ArrayList<String>(stopSequences) : Collections.emptyList();
        this.tokenSelectionBiases = tokenSelectionBiases != null ? new HashMap<Integer, Integer>(tokenSelectionBiases) : Collections.emptyMap();
        this.tokenSelectionBiases.replaceAll((k, v) -> PromptExecutionSettings.clamp(v, -100, 100, 0));
        this.responseFormat = responseFormat == null ? new TextResponseFormat() : responseFormat;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T extends Number> T clamp(T value, T min, T max, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value.doubleValue() < min.doubleValue()) {
            return min;
        }
        if (value.doubleValue() > max.doubleValue()) {
            return max;
        }
        return value;
    }

    @JsonProperty(value="service_id")
    public String getServiceId() {
        return this.serviceId;
    }

    @JsonProperty(value="model_id")
    public String getModelId() {
        return this.modelId;
    }

    @JsonProperty(value="temperature")
    public double getTemperature() {
        return Double.isNaN(this.temperature) ? 1.0 : this.temperature;
    }

    @JsonProperty(value="top_p")
    public double getTopP() {
        return this.topP;
    }

    @JsonProperty(value="presence_penalty")
    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    @JsonProperty(value="frequency_penalty")
    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @JsonProperty(value="max_tokens")
    public int getMaxTokens() {
        return this.maxTokens;
    }

    @JsonProperty(value="results_per_prompt")
    public int getResultsPerPrompt() {
        return this.resultsPerPrompt;
    }

    @JsonProperty(value="best_of")
    public int getBestOf() {
        return this.bestOf;
    }

    @JsonProperty(value="user")
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="stop_sequences")
    public List<String> getStopSequences() {
        return Collections.unmodifiableList(this.stopSequences);
    }

    @JsonProperty(value="token_selection_biases")
    public Map<Integer, Integer> getTokenSelectionBiases() {
        return Collections.unmodifiableMap(this.tokenSelectionBiases);
    }

    public int hashCode() {
        return Objects.hash(this.serviceId, this.modelId, this.temperature, this.topP, this.presencePenalty, this.frequencyPenalty, this.maxTokens, this.bestOf, this.resultsPerPrompt, this.user, this.stopSequences, this.tokenSelectionBiases, this.responseFormat);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        PromptExecutionSettings other = (PromptExecutionSettings)obj;
        if (!Objects.equals(this.serviceId, other.serviceId)) {
            return false;
        }
        if (!Objects.equals(this.modelId, other.modelId)) {
            return false;
        }
        if (Double.compare(this.temperature, other.temperature) != 0) {
            return false;
        }
        if (Double.compare(this.topP, other.topP) != 0) {
            return false;
        }
        if (Double.compare(this.presencePenalty, other.presencePenalty) != 0) {
            return false;
        }
        if (Double.compare(this.frequencyPenalty, other.frequencyPenalty) != 0) {
            return false;
        }
        if (this.maxTokens != other.maxTokens) {
            return false;
        }
        if (this.bestOf != other.bestOf) {
            return false;
        }
        if (this.resultsPerPrompt != other.resultsPerPrompt) {
            return false;
        }
        if (!Objects.equals(this.user, other.user)) {
            return false;
        }
        if (!Objects.equals(this.stopSequences, other.stopSequences)) {
            return false;
        }
        if (!Objects.equals(this.responseFormat, other.responseFormat)) {
            return false;
        }
        return Objects.equals(this.tokenSelectionBiases, other.tokenSelectionBiases);
    }

    @JsonProperty(value="response_format")
    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public static class Builder {
        Map<String, Object> settings = new HashMap<String, Object>();

        public Builder withServiceId(String serviceId) {
            this.settings.put(PromptExecutionSettings.SERVICE_ID, serviceId);
            return this;
        }

        public Builder withModelId(String modelId) {
            this.settings.put(PromptExecutionSettings.MODEL_ID, modelId);
            return this;
        }

        public Builder withTemperature(double temperature) {
            if (!Double.isNaN(temperature)) {
                this.settings.put(PromptExecutionSettings.TEMPERATURE, temperature);
            }
            return this;
        }

        public Builder withTopP(double topP) {
            if (!Double.isNaN(topP)) {
                this.settings.put(PromptExecutionSettings.TOP_P, topP);
            }
            return this;
        }

        public Builder withPresencePenalty(double presencePenalty) {
            if (!Double.isNaN(presencePenalty)) {
                this.settings.put(PromptExecutionSettings.PRESENCE_PENALTY, presencePenalty);
            }
            return this;
        }

        public Builder withFrequencyPenalty(double frequencyPenalty) {
            if (!Double.isNaN(frequencyPenalty)) {
                this.settings.put(PromptExecutionSettings.FREQUENCY_PENALTY, frequencyPenalty);
            }
            return this;
        }

        public Builder withMaxTokens(int maxTokens) {
            this.settings.put(PromptExecutionSettings.MAX_TOKENS, maxTokens);
            return this;
        }

        public Builder withResultsPerPrompt(int resultsPerPrompt) {
            this.settings.put(PromptExecutionSettings.RESULTS_PER_PROMPT, resultsPerPrompt);
            return this;
        }

        public Builder withBestOf(int bestOf) {
            this.settings.put(PromptExecutionSettings.BEST_OF, bestOf);
            return this;
        }

        public Builder withUser(String user) {
            this.settings.put(PromptExecutionSettings.USER, user);
            return this;
        }

        public Builder withStopSequences(List<String> stopSequences) {
            if (stopSequences != null) {
                ((List)this.settings.computeIfAbsent(PromptExecutionSettings.STOP_SEQUENCES, k -> new ArrayList())).addAll(stopSequences);
            }
            return this;
        }

        public Builder withTokenSelectionBiases(Map<Integer, Integer> tokenSelectionBiases) {
            if (tokenSelectionBiases != null) {
                ((Map)this.settings.computeIfAbsent(PromptExecutionSettings.TOKEN_SELECTION_BIASES, k -> new HashMap())).putAll(tokenSelectionBiases);
            }
            return this;
        }

        public Builder withResponseFormat(ResponseFormat responseFormat) {
            if (responseFormat != null) {
                this.settings.put(PromptExecutionSettings.RESPONSE_FORMAT, responseFormat);
            }
            return this;
        }

        public Builder withResponseFormat(ResponseFormat.Type responseFormat) {
            switch (responseFormat) {
                case JSON_OBJECT: {
                    this.settings.put(PromptExecutionSettings.RESPONSE_FORMAT, new JsonObjectResponseFormat());
                    break;
                }
                case TEXT: {
                    this.settings.put(PromptExecutionSettings.RESPONSE_FORMAT, new TextResponseFormat());
                    break;
                }
                case JSON_SCHEMA: {
                    throw new SKException("Cannot set JSON_SCHEMA response format without a schema, use withResponseFormat(ResponseFormat responseFormat)");
                }
            }
            return this;
        }

        public Builder withJsonSchemaResponseFormat(Class<?> responseFormat) {
            if (responseFormat != null) {
                this.settings.put(PromptExecutionSettings.RESPONSE_FORMAT, JsonSchemaResponseFormat.builder().setResponseFormat(responseFormat).setName(responseFormat.getSimpleName()).build());
            }
            return this;
        }

        public PromptExecutionSettings build() {
            return new PromptExecutionSettings((String)this.settings.getOrDefault(PromptExecutionSettings.SERVICE_ID, PromptExecutionSettings.DEFAULT_SERVICE_ID), (String)this.settings.getOrDefault(PromptExecutionSettings.MODEL_ID, ""), (Double)this.settings.getOrDefault(PromptExecutionSettings.TEMPERATURE, 1.0), (Double)this.settings.getOrDefault(PromptExecutionSettings.TOP_P, 1.0), (Double)this.settings.getOrDefault(PromptExecutionSettings.PRESENCE_PENALTY, 0.0), (Double)this.settings.getOrDefault(PromptExecutionSettings.FREQUENCY_PENALTY, 0.0), (Integer)this.settings.getOrDefault(PromptExecutionSettings.MAX_TOKENS, 256), (Integer)this.settings.getOrDefault(PromptExecutionSettings.RESULTS_PER_PROMPT, 1), (Integer)this.settings.getOrDefault(PromptExecutionSettings.BEST_OF, 1), (String)this.settings.getOrDefault(PromptExecutionSettings.USER, ""), this.settings.getOrDefault(PromptExecutionSettings.STOP_SEQUENCES, Collections.emptyList()), this.settings.getOrDefault(PromptExecutionSettings.TOKEN_SELECTION_BIASES, Collections.emptyMap()), (ResponseFormat)this.settings.getOrDefault(PromptExecutionSettings.RESPONSE_FORMAT, new TextResponseFormat()));
        }
    }
}

