/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation.templateengine.tokenizer;

import com.microsoft.semantickernel.implementation.templateengine.tokenizer.CodeTokenizer;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.Block;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.CodeBlock;
import com.microsoft.semantickernel.implementation.templateengine.tokenizer.blocks.TextBlock;
import com.microsoft.semantickernel.templateengine.semantickernel.TemplateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TemplateTokenizer {
    private final CodeTokenizer codeTokenizer = new CodeTokenizer();

    private static String subStr(String text, int startIndex, int stopIndex) {
        return text.substring(startIndex, stopIndex);
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    private static boolean canBeEscaped(char c) {
        return c == '\"' || c == '\'' || c == '\\';
    }

    public List<Block> tokenize(String text) {
        int EMPTY_CODE_BLOCK_LENGTH = 4;
        int MIN_CODE_BLOCK_LENGTH = EMPTY_CODE_BLOCK_LENGTH + 1;
        if (text == null || text.isEmpty()) {
            return Collections.singletonList(new TextBlock(""));
        }
        if (text.length() < MIN_CODE_BLOCK_LENGTH) {
            return Collections.singletonList(new TextBlock(text));
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        int endOfLastBlock = 0;
        int blockStartPos = 0;
        boolean blockStartFound = false;
        boolean insideTextValue = false;
        char textValueDelimiter = '\u0000';
        boolean skipNextChar = false;
        char nextChar = text.charAt(0);
        for (int nextCharCursor = 1; nextCharCursor < text.length(); ++nextCharCursor) {
            String contentWithDelimiters;
            String contentWithoutDelimiters;
            int currentCharPos = nextCharCursor - 1;
            int cursor = nextCharCursor;
            char currentChar = nextChar;
            nextChar = text.charAt(nextCharCursor);
            if (skipNextChar) {
                skipNextChar = false;
                continue;
            }
            if (!insideTextValue && currentChar == '{' && nextChar == '{') {
                blockStartPos = currentCharPos;
                blockStartFound = true;
            }
            if (!blockStartFound) continue;
            if (insideTextValue) {
                if (currentChar == '\\' && TemplateTokenizer.canBeEscaped(nextChar)) {
                    skipNextChar = true;
                    continue;
                }
                if (currentChar != textValueDelimiter) continue;
                insideTextValue = false;
                continue;
            }
            if (TemplateTokenizer.isQuote(currentChar)) {
                insideTextValue = true;
                textValueDelimiter = currentChar;
                continue;
            }
            if (currentChar != '}' || nextChar != '}') continue;
            if (blockStartPos > endOfLastBlock) {
                blocks.add(new TextBlock(text, endOfLastBlock, blockStartPos));
            }
            if ((contentWithoutDelimiters = (contentWithDelimiters = TemplateTokenizer.subStr(text, blockStartPos, cursor + 1)).substring(2, contentWithDelimiters.length() - 2).trim()).isEmpty()) {
                blocks.add(new TextBlock(contentWithDelimiters));
            } else {
                List<Block> codeBlocks = this.codeTokenizer.tokenize(contentWithoutDelimiters);
                switch (codeBlocks.get(0).getType()) {
                    case VARIABLE: {
                        if (codeBlocks.size() > 1) {
                            throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR, "Invalid token detected after the variable: " + contentWithoutDelimiters);
                        }
                        blocks.add(codeBlocks.get(0));
                        break;
                    }
                    case VALUE: {
                        if (codeBlocks.size() > 1) {
                            throw new TemplateException(TemplateException.ErrorCodes.SYNTAX_ERROR, "Invalid token detected after the value: " + contentWithoutDelimiters);
                        }
                        blocks.add(codeBlocks.get(0));
                        break;
                    }
                    case FUNCTION_ID: {
                        blocks.add(new CodeBlock(codeBlocks, contentWithoutDelimiters));
                        break;
                    }
                    default: {
                        throw new TemplateException(TemplateException.ErrorCodes.UNEXPECTED_BLOCK_TYPE, "Code tokenizer returned an incorrect first token type " + (Object)((Object)codeBlocks.get(0).getType()));
                    }
                }
            }
            endOfLastBlock = cursor + 1;
            blockStartFound = false;
        }
        if (endOfLastBlock < text.length()) {
            blocks.add(new TextBlock(text, endOfLastBlock, text.length()));
        }
        return Collections.unmodifiableList(blocks);
    }
}

