/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services.textembedding;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

final class VectorOperations {
    VectorOperations() {
    }

    static float cosineSimilarity(@Nonnull List<Float> x, @Nonnull List<Float> y) {
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("Vectors lengths must be equal");
        }
        float dotProduct = VectorOperations.dot(x, y);
        float normX = VectorOperations.dot(x, x);
        float normY = VectorOperations.dot(y, y);
        if (normX == 0.0f || normY == 0.0f) {
            throw new IllegalArgumentException("Vectors cannot have zero norm");
        }
        return dotProduct / (float)(Math.sqrt(normX) * Math.sqrt(normY));
    }

    static List<Float> divide(@Nonnull List<Float> vector, float divisor) {
        Objects.requireNonNull(vector);
        if (Float.isNaN(divisor)) {
            throw new IllegalArgumentException("Divisor cannot be NaN");
        }
        if (divisor == 0.0f) {
            throw new IllegalArgumentException("Divisor cannot be zero");
        }
        return vector.stream().map(x -> Float.valueOf(x.floatValue() / divisor)).collect(Collectors.toList());
    }

    static float dot(@Nonnull List<Float> x, @Nonnull List<Float> y) {
        Objects.requireNonNull(x);
        Objects.requireNonNull(y);
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("Vectors lengths must be equal");
        }
        float result = 0.0f;
        for (int i = 0; i < x.size(); ++i) {
            result += x.get(i).floatValue() * y.get(i).floatValue();
        }
        return result;
    }

    static float euclideanLength(@Nonnull List<Float> vector) {
        Objects.requireNonNull(vector);
        return (float)Math.sqrt(VectorOperations.dot(vector, vector));
    }

    static List<Float> multiply(@Nonnull List<Float> vector, float multiplier) {
        Objects.requireNonNull(vector);
        if (Float.isNaN(multiplier)) {
            throw new IllegalArgumentException("Multiplier cannot be NaN");
        }
        if (Float.isInfinite(multiplier)) {
            throw new IllegalArgumentException("Multiplier cannot be infinite");
        }
        return vector.stream().map(x -> Float.valueOf(x.floatValue() * multiplier)).collect(Collectors.toList());
    }

    static List<Float> normalize(@Nonnull List<Float> vector) {
        Objects.requireNonNull(vector);
        return VectorOperations.divide(vector, VectorOperations.euclideanLength(vector));
    }
}

