/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.implementation.chatcompletion;

import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.exceptions.SKException;
import com.microsoft.semantickernel.implementation.chatcompletion.ChatPromptParseVisitor;
import com.microsoft.semantickernel.orchestration.ToolCallBehavior;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatXMLPromptParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChatXMLPromptParser.class);

    public static <T> ChatPromptParseVisitor<T> parse(String rawPrompt, ChatPromptParseVisitor<T> chatPromptParseVisitor) {
        List<String> prompts = Arrays.asList(rawPrompt, "<prompt>" + rawPrompt + "</prompt>");
        for (String prompt : prompts) {
            try {
                chatPromptParseVisitor = ChatXMLPromptParser.getChatRequestMessages(prompt, chatPromptParseVisitor);
                if ((chatPromptParseVisitor = ChatXMLPromptParser.getFunctionDefinitions(prompt, chatPromptParseVisitor)).areMessagesEmpty()) continue;
                return chatPromptParseVisitor;
            }
            catch (SKException e) {
                chatPromptParseVisitor = chatPromptParseVisitor.reset();
            }
        }
        return chatPromptParseVisitor.fromRawPrompt(rawPrompt);
    }

    private static <T> ChatPromptParseVisitor<T> getChatRequestMessages(String prompt, ChatPromptParseVisitor<T> chatPromptParseVisitor) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(prompt.getBytes(StandardCharsets.UTF_8));){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createXMLEventReader(is);
            while (reader.hasNext()) {
                String name;
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !(name = ChatXMLPromptParser.getElementName(event)).equals("message")) continue;
                String role = ChatXMLPromptParser.getAttributeValue(event, "role");
                String content = reader.getElementText();
                chatPromptParseVisitor = chatPromptParseVisitor.addMessage(role, content);
            }
        }
        catch (IOException | IllegalArgumentException | XMLStreamException e) {
            throw new SKException("Failed to parse messages");
        }
        return chatPromptParseVisitor;
    }

    private static <T> ChatPromptParseVisitor<T> getFunctionDefinitions(String prompt, ChatPromptParseVisitor<T> chatPromptParseVisitor) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(prompt.getBytes(StandardCharsets.UTF_8));){
            XMLInputFactory factory = XMLInputFactory.newFactory();
            XMLEventReader reader = factory.createXMLEventReader(is);
            FunctionDefinition functionDefinition = null;
            HashMap<String, String> parameters = new HashMap<String, String>();
            ArrayList<String> requiredParameters = new ArrayList<String>();
            while (reader.hasNext()) {
                String elementName;
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    String description;
                    elementName = ChatXMLPromptParser.getElementName(event);
                    if (elementName.equals("function")) {
                        assert (functionDefinition == null);
                        assert (parameters.isEmpty());
                        assert (requiredParameters.isEmpty());
                        String pluginName = ChatXMLPromptParser.getAttributeValue(event, "pluginName");
                        String name2 = ChatXMLPromptParser.getAttributeValue(event, "name");
                        description = ChatXMLPromptParser.getAttributeValue(event, "description");
                        functionDefinition = new FunctionDefinition(ToolCallBehavior.formFullFunctionName(pluginName, name2), description);
                        continue;
                    }
                    if (!elementName.equals("parameter")) continue;
                    String name3 = ChatXMLPromptParser.getAttributeValue(event, "name");
                    String type = ChatXMLPromptParser.getAttributeValue(event, "type").toLowerCase(Locale.ROOT);
                    description = ChatXMLPromptParser.getAttributeValue(event, "description");
                    parameters.put(name3, String.format("{\"type\": \"%s\", \"description\": \"%s\"}", "string", description));
                    String isRequired = ChatXMLPromptParser.getAttributeValue(event, "isRequired");
                    if (!Boolean.parseBoolean(isRequired)) continue;
                    requiredParameters.add(name3);
                    continue;
                }
                if (!event.isEndElement() || !(elementName = ChatXMLPromptParser.getElementName(event)).equals("function")) continue;
                if (functionDefinition == null) {
                    throw new SKException("Failed to parse function definition");
                }
                if (!parameters.isEmpty()) {
                    StringBuilder sb = new StringBuilder("{\"type\": \"object\", \"properties\": {");
                    parameters.forEach((name, value) -> sb.append(String.format("\"%s\": %s,", name, value)));
                    sb.replace(sb.length() - 1, sb.length(), "}");
                    if (!requiredParameters.isEmpty()) {
                        sb.append(", \"required\": [");
                        requiredParameters.forEach(name -> sb.append(String.format("\"%s\",", name)));
                        sb.replace(sb.length() - 1, sb.length(), "]");
                    }
                    sb.append("}");
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode jsonNode = objectMapper.readTree(sb.toString());
                    BinaryData binaryData = BinaryData.fromObject((Object)jsonNode);
                    functionDefinition.setParameters(binaryData);
                }
                chatPromptParseVisitor = chatPromptParseVisitor.addFunction(functionDefinition.name, functionDefinition.description, functionDefinition.parameters);
                functionDefinition = null;
                parameters.clear();
                requiredParameters.clear();
            }
        }
        catch (IOException | IllegalArgumentException | XMLStreamException e) {
            LOGGER.error("Error parsing prompt", (Throwable)e);
        }
        return chatPromptParseVisitor;
    }

    private static String getElementName(XMLEvent xmlEvent) {
        if (xmlEvent.isStartElement()) {
            return xmlEvent.asStartElement().getName().getLocalPart();
        }
        if (xmlEvent.isEndElement()) {
            return xmlEvent.asEndElement().getName().getLocalPart();
        }
        return "";
    }

    private static String getAttributeValue(XMLEvent xmlEvent, String attributeName) {
        if (xmlEvent.isStartElement()) {
            StartElement element = xmlEvent.asStartElement();
            Attribute attribute = element.getAttributeByName(QName.valueOf(attributeName));
            return attribute != null ? attribute.getValue() : "";
        }
        return "";
    }

    private static class FunctionDefinition {
        private final String name;
        private final String description;
        @Nullable
        private BinaryData parameters;

        public FunctionDefinition(String name, String description) {
            this.name = name;
            this.description = description;
            this.parameters = null;
        }

        public void setParameters(BinaryData binaryData) {
            this.parameters = binaryData;
        }
    }
}

