/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.hooks;

import com.microsoft.semantickernel.hooks.FunctionInvokedEvent;
import com.microsoft.semantickernel.hooks.FunctionInvokingEvent;
import com.microsoft.semantickernel.hooks.KernelHook;
import com.microsoft.semantickernel.hooks.KernelHookEvent;
import com.microsoft.semantickernel.hooks.PostChatCompletionEvent;
import com.microsoft.semantickernel.hooks.PreChatCompletionEvent;
import com.microsoft.semantickernel.hooks.PreToolCallEvent;
import com.microsoft.semantickernel.hooks.PromptRenderedEvent;
import com.microsoft.semantickernel.hooks.PromptRenderingEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;

public class KernelHooks {
    private final Map<String, KernelHook<?>> hooks = new HashMap();

    public KernelHooks() {
    }

    public KernelHooks(@Nullable KernelHooks kernelHooks) {
        this();
        if (kernelHooks != null) {
            this.hooks.putAll(kernelHooks.getHooks());
        }
    }

    public KernelHooks(Map<String, KernelHook<?>> hooks) {
        this();
        this.hooks.putAll(hooks);
    }

    public UnmodifiableKernelHooks unmodifiableClone() {
        return new UnmodifiableKernelHooks(this);
    }

    protected Map<String, KernelHook<?>> getHooks() {
        return Collections.unmodifiableMap(this.hooks);
    }

    public String addFunctionInvokingHook(Function<FunctionInvokingEvent<?>, FunctionInvokingEvent<?>> function) {
        return this.addHook(function::apply);
    }

    public String addFunctionInvokedHook(Function<FunctionInvokedEvent<?>, FunctionInvokedEvent<?>> function) {
        return this.addHook(function::apply);
    }

    public String addPreChatCompletionHook(Function<PreChatCompletionEvent, PreChatCompletionEvent> function) {
        return this.addHook(function::apply);
    }

    public String addPreToolCallHook(Function<PreToolCallEvent, PreToolCallEvent> function) {
        return this.addHook(function::apply);
    }

    public String addPostChatCompletionHook(Function<PostChatCompletionEvent, PostChatCompletionEvent> function) {
        return this.addHook(function::apply);
    }

    public String addPromptRenderedHook(Function<PromptRenderedEvent, PromptRenderedEvent> function) {
        return this.addHook(function::apply);
    }

    public String addPromptRenderingHook(Function<PromptRenderingEvent, PromptRenderingEvent> function) {
        return this.addHook(function::apply);
    }

    public <T extends KernelHookEvent> T executeHooks(T event) {
        return (T)this.hooks.values().stream().filter(hook -> hook.test(event)).sorted(Comparator.comparingInt(KernelHook::getPriority)).reduce(event, (event2, hook) -> (KernelHookEvent)hook.apply(event2), (a, b) -> {
            throw new UnsupportedOperationException("No merging for hooks");
        });
    }

    public String addHook(KernelHook<?> hook) {
        return this.addHook(UUID.randomUUID().toString(), hook);
    }

    public String addHook(String hookName, KernelHook<?> hook) {
        this.hooks.put(hookName, hook);
        return hookName;
    }

    public KernelHook<?> removeHook(String hookName) {
        return this.hooks.remove(hookName);
    }

    public KernelHooks addHooks(@Nullable KernelHooks kernelHooks) {
        if (kernelHooks == null) {
            return this;
        }
        this.hooks.putAll(kernelHooks.getHooks());
        return this;
    }

    public boolean isEmpty() {
        return this.hooks.isEmpty();
    }

    public static KernelHooks merge(@Nullable KernelHooks a, @Nullable KernelHooks b) {
        KernelHooks hooks = a;
        if (hooks == null) {
            hooks = new KernelHooks();
        }
        if (b == null) {
            return hooks;
        }
        if (hooks.isEmpty()) {
            return b;
        }
        HashMap merged = new HashMap(hooks.getHooks());
        merged.putAll(b.getHooks());
        return new KernelHooks(merged);
    }

    public static class UnmodifiableKernelHooks
    extends KernelHooks {
        private UnmodifiableKernelHooks(KernelHooks kernelHooks) {
            super(kernelHooks);
        }

        @Override
        public String addFunctionInvokingHook(Function<FunctionInvokingEvent<?>, FunctionInvokingEvent<?>> function) {
            throw new UnsupportedOperationException("unmodifiable instance of KernelHooks");
        }

        @Override
        public String addFunctionInvokedHook(Function<FunctionInvokedEvent<?>, FunctionInvokedEvent<?>> function) {
            throw new UnsupportedOperationException("unmodifiable instance of KernelHooks");
        }

        @Override
        public String addPreChatCompletionHook(Function<PreChatCompletionEvent, PreChatCompletionEvent> function) {
            throw new UnsupportedOperationException("unmodifiable instance of KernelHooks");
        }

        @Override
        public String addPostChatCompletionHook(Function<PostChatCompletionEvent, PostChatCompletionEvent> function) {
            throw new UnsupportedOperationException("unmodifiable instance of KernelHooks");
        }

        @Override
        public String addPromptRenderedHook(Function<PromptRenderedEvent, PromptRenderedEvent> function) {
            throw new UnsupportedOperationException("unmodifiable instance of KernelHooks");
        }

        @Override
        public String addPromptRenderingHook(Function<PromptRenderingEvent, PromptRenderingEvent> function) {
            throw new UnsupportedOperationException("unmodifiable instance of KernelHooks");
        }

        @Override
        public String addHook(KernelHook<?> hook) {
            throw new UnsupportedOperationException("unmodifiable instance of KernelHooks");
        }

        @Override
        public String addHook(String hookName, KernelHook<?> hook) {
            throw new UnsupportedOperationException("unmodifiable instance of KernelHooks");
        }

        @Override
        public KernelHooks addHooks(@Nullable KernelHooks kernelHooks) {
            throw new UnsupportedOperationException("unmodifiable instance of KernelHooks");
        }

        @Override
        public KernelHook<?> removeHook(String hookName) {
            throw new UnsupportedOperationException("unmodifiable instance of KernelHooks");
        }
    }
}

