/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class EmbeddedResourceLoader {
    public static String readFile(String fileName, Class<?> clazz) throws FileNotFoundException {
        return EmbeddedResourceLoader.readFile(fileName, clazz, ResourceLocation.CLASSPATH);
    }

    public static String readFile(String fileName, Class<?> clazz, ResourceLocation ... locations) throws FileNotFoundException {
        List locationsList = Arrays.stream(locations).collect(Collectors.toList());
        Optional<String> fileContents = locationsList.stream().map(type -> {
            switch (type) {
                case CLASSPATH: {
                    try (InputStream inputStream22 = clazz.getResourceAsStream(fileName);){
                        String string = EmbeddedResourceLoader.readInputStream(fileName, inputStream22);
                        return string;
                    }
                    catch (Exception inputStream22) {
                        return null;
                    }
                }
                case CLASSPATH_ROOT: {
                    try (InputStream inputStream32 = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
                        String string = EmbeddedResourceLoader.readInputStream(fileName, inputStream32);
                        return string;
                    }
                    catch (IOException inputStream32) {
                        return null;
                    }
                }
                case FILESYSTEM: {
                    File file = new File(fileName);
                    if (!file.exists()) return null;
                    try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                        String string = EmbeddedResourceLoader.readInputStream(fileName, inputStream);
                        return string;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
        if (fileContents.isPresent()) {
            return fileContents.get();
        }
        throw new FileNotFoundException("Could not find file " + fileName);
    }

    private static String readInputStream(String fileName, InputStream inputStream) throws FileNotFoundException {
        if (inputStream == null) {
            throw new FileNotFoundException("File not found: " + fileName);
        }
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
    }

    public static enum ResourceLocation {
        CLASSPATH,
        FILESYSTEM,
        CLASSPATH_ROOT;

    }
}

