/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services;

import com.microsoft.semantickernel.Verify;
import com.microsoft.semantickernel.ai.embeddings.EmbeddingGeneration;
import com.microsoft.semantickernel.ai.embeddings.TextEmbeddingGeneration;
import com.microsoft.semantickernel.chatcompletion.ChatCompletion;
import com.microsoft.semantickernel.services.AIService;
import com.microsoft.semantickernel.services.AIServiceProvider;
import com.microsoft.semantickernel.services.DefaultAIServiceProvider;
import com.microsoft.semantickernel.textcompletion.TextCompletion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AIServiceCollection {
    private static final String DefaultKey = "__DEFAULT__";
    private static final List<Class<? extends AIService>> KNOWN_SERVICES = Arrays.asList(EmbeddingGeneration.class, TextEmbeddingGeneration.class, TextCompletion.class, ChatCompletion.class);
    private final Map<Class<? extends AIService>, Map<String, Supplier<? extends AIService>>> services = new HashMap<Class<? extends AIService>, Map<String, Supplier<? extends AIService>>>();
    private final Map<Class<? extends AIService>, String> defaultIds = new HashMap<Class<? extends AIService>, String>();

    public <T extends AIService> void setService(T service, Class<T> serviceType) {
        this.setService(DefaultKey, () -> service, true, serviceType);
    }

    public <T extends AIService> void setService(String name, T service, boolean setAsDefault, Class<T> serviceType) {
        this.setService(name, () -> service, setAsDefault, serviceType);
    }

    public <T extends AIService> void setService(Supplier<T> factory, Class<T> serviceType) {
        this.setService(DefaultKey, factory, true, serviceType);
    }

    public <T extends AIService> void setService(@Nullable String name, Supplier<T> factory, boolean setAsDefault, Class<T> specificServiceType) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        this.getKnownServiceTypes(specificServiceType).forEach(serviceType -> {
            Map namedServices = this.services.computeIfAbsent((Class<? extends AIService>)serviceType, ignore -> new HashMap());
            if (name == null || setAsDefault || !this.hasDefault((Class)serviceType)) {
                this.defaultIds.put((Class<? extends AIService>)serviceType, name == null ? DefaultKey : name);
            }
            namedServices.put(name == null ? DefaultKey : name, factory);
        });
    }

    private <T extends AIService> List<Class<? extends AIService>> getKnownServiceTypes(Class<T> serviceType) {
        ArrayList knownServices = KNOWN_SERVICES.stream().filter(knownServiceType -> knownServiceType.isAssignableFrom(serviceType)).collect(Collectors.toCollection(ArrayList::new));
        knownServices.add(serviceType);
        return knownServices;
    }

    public AIServiceProvider build() {
        Map<Class<? extends AIService>, Map<String, Supplier<? extends AIService>>> servicesClone = AIServiceCollection.cloneServices(this.services);
        HashMap<Class<? extends AIService>, String> defaultsClone = new HashMap<Class<? extends AIService>, String>(this.defaultIds);
        return new DefaultAIServiceProvider(servicesClone, (Map<Class<? extends AIService>, String>)defaultsClone);
    }

    static <T> Map<Class<? extends T>, Map<String, Supplier<? extends T>>> cloneServices(Map<Class<? extends T>, Map<String, Supplier<? extends T>>> services) {
        return Collections.unmodifiableMap(services.entrySet().stream().reduce(new HashMap(), (a, b) -> {
            a.put((Class)b.getKey(), Collections.unmodifiableMap((Map)b.getValue()));
            return a;
        }, (a, b) -> {
            a.putAll(b);
            return a;
        }));
    }

    private <T extends AIService> boolean hasDefault(Class<T> type) {
        String defaultName = this.defaultIds.get(type);
        return !Verify.isNullOrEmpty(defaultName);
    }
}

