/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.memory;

import com.microsoft.semantickernel.memory.MemoryRecordMetadata;
import javax.annotation.Nonnull;

public class MemoryQueryResult {
    @Nonnull
    private final MemoryRecordMetadata metadata;
    private final double relevance;

    public MemoryQueryResult(@Nonnull MemoryRecordMetadata metadata, double relevance) {
        this.metadata = metadata;
        this.relevance = MemoryQueryResult.clampRelevance(relevance);
    }

    public MemoryRecordMetadata getMetadata() {
        return this.metadata;
    }

    public double getRelevance() {
        return this.relevance;
    }

    private static double clampRelevance(double relevance) {
        return !Double.isNaN(relevance) ? Math.max(0.0, Math.min(1.0, relevance)) : 0.0;
    }
}

