/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.aiservices.openai.chatcompletion;

import com.azure.ai.openai.models.FunctionDefinition;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.semantickernel.semanticfunctions.InputVariable;
import com.microsoft.semantickernel.semanticfunctions.KernelFunctionMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class OpenAIFunction {
    private final String pluginName;
    private final String name;
    private final FunctionDefinition functionDefinition;

    protected OpenAIFunction(@Nonnull String name, @Nonnull String pluginName, @Nonnull FunctionDefinition functionDefinition) {
        this.name = name;
        this.pluginName = pluginName;
        this.functionDefinition = functionDefinition;
    }

    public static OpenAIFunction build(KernelFunctionMetadata<?> metadata, String pluginName) {
        String name = metadata.getName();
        FunctionDefinition functionDefinition = OpenAIFunction.toFunctionDefinition(metadata, pluginName);
        return new OpenAIFunction(name, pluginName, functionDefinition);
    }

    public String getName() {
        return this.name;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public FunctionDefinition getFunctionDefinition() {
        return this.functionDefinition;
    }

    public static String getNameSeparator() {
        return "-";
    }

    private static String getFullyQualifiedName(@Nullable String pluginName, String functionName) {
        return pluginName == null || pluginName.isEmpty() ? functionName : pluginName + OpenAIFunction.getNameSeparator() + functionName;
    }

    public static FunctionDefinition toFunctionDefinition(KernelFunctionMetadata<?> metadata, @Nullable String pluginName) {
        BinaryData resultParameters;
        HashMap<String, JsonNode> properties = new HashMap<String, JsonNode>();
        ArrayList<String> required = new ArrayList<String>();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            for (InputVariable parameter : metadata.getParameters()) {
                String parameterJsonSchema = OpenAIFunction.getSchemaForFunctionParameter(parameter);
                properties.put(parameter.getName(), objectMapper.readTree(parameterJsonSchema));
                if (!parameter.isRequired()) continue;
                required.add(parameter.getName());
            }
            String json = objectMapper.writeValueAsString((Object)new OpenAIFunctionParameter("object", required, properties));
            resultParameters = BinaryData.fromObject((Object)objectMapper.readTree(json));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        FunctionDefinition functionDefinition = new FunctionDefinition(OpenAIFunction.getFullyQualifiedName(pluginName, metadata.getName()));
        functionDefinition.setDescription(metadata.getDescription());
        functionDefinition.setParameters(resultParameters);
        return functionDefinition;
    }

    private static String getSchemaForFunctionParameter(@Nullable InputVariable parameter) {
        ArrayList<String> entries = new ArrayList<String>();
        entries.add("\"type\":\"string\"");
        if (parameter != null && parameter.getDescription() != null && !parameter.getDescription().isEmpty()) {
            String description = parameter.getDescription();
            description = description.replaceAll("\\r?\\n|\\r", "");
            description = description.replace("\"", "\\\"");
            description = String.format("\"description\":\"%s\"", description);
            entries.add(description);
        }
        if (parameter != null && parameter.getEnumValues() != null && !parameter.getEnumValues().isEmpty()) {
            String enumEntry = parameter.getEnumValues().stream().map(Object::toString).map(it -> "\"" + it + "\"").collect(Collectors.joining(","));
            entries.add("\"enum\":[ " + enumEntry + " ]");
        }
        String schema = String.join((CharSequence)",", entries);
        return "{" + schema + "}";
    }

    private static class OpenAIFunctionParameter {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="required")
        private List<String> required;
        @JsonProperty(value="properties")
        private Map<String, JsonNode> properties;

        public OpenAIFunctionParameter(String type, List<String> required, Map<String, JsonNode> properties) {
            this.type = type;
            this.required = Collections.unmodifiableList(required);
            this.properties = Collections.unmodifiableMap(properties);
        }

        public String getType() {
            return this.type;
        }

        public List<String> getRequired() {
            return this.required;
        }

        public Map<String, JsonNode> getProperties() {
            return this.properties;
        }
    }
}

