/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public final class DateTimeSerializer
extends JsonSerializer<OffsetDateTime> {
    public static SimpleModule getModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(OffsetDateTime.class, (JsonSerializer)new DateTimeSerializer());
        return module;
    }

    public void serialize(OffsetDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jgen.writeNumber(value.toInstant().toEpochMilli());
        } else {
            jgen.writeString(DateTimeSerializer.toString(value));
        }
    }

    public static String toString(OffsetDateTime offsetDateTime) {
        String result = null;
        if (offsetDateTime != null && (result = DateTimeFormatter.ISO_INSTANT.format(offsetDateTime = offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC))).startsWith("+")) {
            result = result.substring(1);
        }
        return result;
    }
}

