/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import com.microsoft.rest.v2.http.ConcurrentMultiHashMap;
import com.microsoft.rest.v2.http.SharedChannelPoolOptions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SharedChannelPool
implements ChannelPool {
    private static final AttributeKey<URI> CHANNEL_URI = AttributeKey.newInstance((String)"channel-uri");
    private static final AttributeKey<ZonedDateTime> CHANNEL_AVAILABLE_SINCE = AttributeKey.newInstance((String)"channel-available-since");
    private static final AttributeKey<ZonedDateTime> CHANNEL_LEASED_SINCE = AttributeKey.newInstance((String)"channel-leased-since");
    private static final AttributeKey<ZonedDateTime> CHANNEL_CREATED_SINCE = AttributeKey.newInstance((String)"channel-created-since");
    private static final AttributeKey<ZonedDateTime> CHANNEL_CLOSED_SINCE = AttributeKey.newInstance((String)"channel-closed-since");
    private final Bootstrap bootstrap;
    private final ChannelPoolHandler handler;
    private final int poolSize;
    private final AtomicInteger channelCount = new AtomicInteger(0);
    private final SharedChannelPoolOptions poolOptions;
    private final Queue<ChannelRequest> requests;
    private final ConcurrentMultiHashMap<URI, Channel> available;
    private final ConcurrentMultiHashMap<URI, Channel> leased;
    private final Object sync = new Object();
    private final SslContext sslContext;
    private final ExecutorService executor;
    private volatile boolean closed = false;
    private final Logger logger = LoggerFactory.getLogger(SharedChannelPool.class);

    private boolean isChannelHealthy(Channel channel) {
        try {
            long channelIdleDurationInSec;
            if (!channel.isActive()) {
                return false;
            }
            if (channel.pipeline().get("HttpResponseDecoder") == null && channel.pipeline().get("HttpClientCodec") == null) {
                return false;
            }
            ZonedDateTime channelAvailableSince = (ZonedDateTime)channel.attr(CHANNEL_AVAILABLE_SINCE).get();
            if (channelAvailableSince == null) {
                channelAvailableSince = (ZonedDateTime)channel.attr(CHANNEL_LEASED_SINCE).get();
            }
            return (channelIdleDurationInSec = ChronoUnit.SECONDS.between(channelAvailableSince, ZonedDateTime.now(ZoneOffset.UTC))) < this.poolOptions.idleChannelKeepAliveDurationInSec();
        }
        catch (Throwable t) {
            return false;
        }
    }

    SharedChannelPool(Bootstrap bootstrap, final ChannelPoolHandler handler, int size, SharedChannelPoolOptions options, SslContext sslContext) {
        this.poolOptions = options.clone();
        this.bootstrap = (Bootstrap)bootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                assert (ch.eventLoop().inEventLoop());
                handler.channelCreated(ch);
            }
        });
        this.handler = handler;
        this.poolSize = size;
        this.requests = new ConcurrentLinkedDeque<ChannelRequest>();
        this.available = new ConcurrentMultiHashMap();
        this.leased = new ConcurrentMultiHashMap();
        try {
            this.sslContext = sslContext == null ? SslContextBuilder.forClient().build() : sslContext;
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        this.executor = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable, "SharedChannelPool-worker");
            thread.setDaemon(true);
            return thread;
        });
        this.executor.submit(() -> {
            while (!this.closed) {
                try {
                    Object object = this.requests;
                    synchronized (object) {
                        while (this.requests.isEmpty() && !this.closed) {
                            this.requests.wait();
                        }
                    }
                    ChannelRequest request = this.requests.remove();
                    object = this.sync;
                    synchronized (object) {
                        while (this.channelCount.get() >= this.poolSize && this.available.size() == 0 && !this.closed) {
                            this.sync.wait();
                        }
                        if (this.closed) {
                            break;
                        }
                        boolean foundHealthyChannelInPool = false;
                        while (this.available.containsKey(request.channelURI)) {
                            Channel channel = this.available.poll(request.channelURI);
                            if (this.isChannelHealthy(channel)) {
                                handler.channelAcquired(channel);
                                request.promise.setSuccess((Object)channel);
                                this.leased.put(request.channelURI, channel);
                                foundHealthyChannelInPool = true;
                                channel.attr(CHANNEL_LEASED_SINCE).set((Object)ZonedDateTime.now(ZoneOffset.UTC));
                                this.logger.debug("Channel picked up from pool: {}", (Object)channel.id());
                                break;
                            }
                            this.logger.debug("Channel disposed from pool due to timeout or half closure: {}", (Object)channel.id());
                            this.closeChannel(channel);
                        }
                        if (!foundHealthyChannelInPool) {
                            while (this.available.size() > 0 && this.channelCount.get() >= this.poolSize) {
                                Channel nextAvailable = this.available.poll();
                                this.logger.debug("Channel disposed due to overflow: {}", (Object)nextAvailable.id());
                                this.closeChannel(nextAvailable);
                            }
                            int port = request.destinationURI.getPort() < 0 ? ("https".equals(request.destinationURI.getScheme()) ? 443 : 80) : request.destinationURI.getPort();
                            this.channelCount.incrementAndGet();
                            this.bootstrap.clone().connect(request.destinationURI.getHost(), port).addListener(f -> {
                                if (f.isSuccess()) {
                                    Channel channel = f.channel();
                                    channel.attr(CHANNEL_URI).set((Object)request.channelURI);
                                    if ("https".equalsIgnoreCase(request.destinationURI.getScheme())) {
                                        channel.pipeline().addFirst(new ChannelHandler[]{this.sslContext.newHandler(channel.alloc(), request.destinationURI.getHost(), port)});
                                    }
                                    if (request.proxy != null) {
                                        channel.pipeline().addFirst("HttpProxyHandler", (ChannelHandler)new HttpProxyHandler(request.proxy.address()));
                                    }
                                    this.leased.put(request.channelURI, channel);
                                    channel.attr(CHANNEL_CREATED_SINCE).set((Object)ZonedDateTime.now(ZoneOffset.UTC));
                                    channel.attr(CHANNEL_LEASED_SINCE).set((Object)ZonedDateTime.now(ZoneOffset.UTC));
                                    this.logger.debug("Channel created: {}", (Object)channel.id());
                                    handler.channelAcquired(channel);
                                    request.promise.setSuccess((Object)channel);
                                } else {
                                    request.promise.setFailure(f.cause());
                                }
                            });
                        }
                    }
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        });
    }

    SharedChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, int size) {
        this(bootstrap, handler, size, new SharedChannelPoolOptions(), null);
    }

    public Future<Channel> acquire(URI uri, @Nullable Proxy proxy) {
        return this.acquire(uri, proxy, (Promise<Channel>)this.bootstrap.config().group().next().newPromise());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Channel> acquire(URI uri, @Nullable Proxy proxy, Promise<Channel> promise) {
        if (this.closed) {
            throw new RejectedExecutionException("SharedChannelPool is closed");
        }
        ChannelRequest channelRequest = new ChannelRequest();
        channelRequest.promise = promise;
        channelRequest.proxy = proxy;
        int port = uri.getPort() < 0 ? ("https".equals(uri.getScheme()) ? 443 : 80) : uri.getPort();
        try {
            Object address;
            channelRequest.destinationURI = new URI(String.format("%s://%s:%d", uri.getScheme(), uri.getHost(), port));
            if (proxy == null) {
                channelRequest.channelURI = channelRequest.destinationURI;
            } else {
                address = (InetSocketAddress)proxy.address();
                channelRequest.channelURI = new URI(String.format("%s://%s:%d", uri.getScheme(), ((InetSocketAddress)address).getHostString(), ((InetSocketAddress)address).getPort()));
            }
            this.requests.add(channelRequest);
            address = this.requests;
            synchronized (address) {
                this.requests.notify();
            }
        }
        catch (URISyntaxException e) {
            promise.setFailure((Throwable)e);
        }
        return channelRequest.promise;
    }

    public Future<Channel> acquire() {
        throw new UnsupportedOperationException("Please pass host & port to shared channel pool.");
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        throw new UnsupportedOperationException("Please pass host & port to shared channel pool.");
    }

    private Future<Void> closeChannel(Channel channel) {
        channel.attr(CHANNEL_CLOSED_SINCE).set((Object)ZonedDateTime.now(ZoneOffset.UTC));
        this.logger.debug("Channel initiated to close: " + channel.id());
        return channel.close().addListener(f -> {
            if (!f.isSuccess()) {
                this.logger.warn("Possible channel leak: failed to close " + channel.id(), f.cause());
            }
        });
    }

    public Future<Void> closeAndRelease(Channel channel) {
        return this.closeChannel(channel).addListener(future -> {
            Object object = this.sync;
            synchronized (object) {
                this.leased.remove((URI)channel.attr(CHANNEL_URI).get(), channel);
                this.channelCount.decrementAndGet();
                this.logger.debug("Channel closed and released out of pool: " + channel.id());
                this.sync.notify();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> release(Channel channel) {
        try {
            this.handler.channelReleased(channel);
            Object object = this.sync;
            synchronized (object) {
                this.leased.remove((URI)channel.attr(CHANNEL_URI).get(), channel);
                if (this.isChannelHealthy(channel)) {
                    this.available.put((URI)channel.attr(CHANNEL_URI).get(), channel);
                    channel.attr(CHANNEL_AVAILABLE_SINCE).set((Object)ZonedDateTime.now(ZoneOffset.UTC));
                    this.logger.debug("Channel released to pool: " + channel.id());
                } else {
                    this.channelCount.decrementAndGet();
                    this.logger.debug("Channel broken on release, dispose: " + channel.id());
                }
                this.sync.notify();
            }
        }
        catch (Exception e) {
            return this.bootstrap.config().group().next().newFailedFuture((Throwable)e);
        }
        return this.bootstrap.config().group().next().newSucceededFuture(null);
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        return this.release(channel).addListener(f -> {
            if (f.isSuccess()) {
                promise.setSuccess(null);
            } else {
                promise.setFailure(f.cause());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        this.executor.shutdownNow();
        Queue<ChannelRequest> queue = this.requests;
        synchronized (queue) {
            while (!this.requests.isEmpty()) {
                this.requests.remove().promise.setFailure((Throwable)new CancellationException("Channel pool was closed"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        Object object = this.sync;
        synchronized (object) {
            long age;
            long stateFor;
            this.logger.info(String.format("---- %s: size %d, keep alive (sec) %d ----", this.toString(), this.poolSize, this.poolOptions.idleChannelKeepAliveDurationInSec()));
            this.logger.info("Channel\tState\tFor\tAge\tURL");
            ArrayList<Channel> closed = new ArrayList<Channel>();
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
            for (Channel channel : this.leased.values()) {
                if (channel.hasAttr(CHANNEL_CLOSED_SINCE)) {
                    closed.add(channel);
                    continue;
                }
                stateFor = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_LEASED_SINCE).get(), now);
                age = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_CREATED_SINCE).get(), now);
                this.logger.info(String.format("%s\tLEASE\t%ds\t%ds\t%s", channel.id(), stateFor, age, channel.attr(CHANNEL_URI).get()));
            }
            for (Channel channel : this.available.values()) {
                if (channel.hasAttr(CHANNEL_CLOSED_SINCE)) {
                    closed.add(channel);
                    continue;
                }
                stateFor = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_AVAILABLE_SINCE).get(), now);
                age = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_CREATED_SINCE).get(), now);
                this.logger.info(String.format("%s\tAVAIL\t%ds\t%ds\t%s", channel.id(), stateFor, age, channel.attr(CHANNEL_URI).get()));
            }
            for (Channel channel : closed) {
                stateFor = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_CLOSED_SINCE).get(), now);
                age = ChronoUnit.SECONDS.between((Temporal)channel.attr(CHANNEL_CREATED_SINCE).get(), now);
                this.logger.info(String.format("%s\tCLOSE\t%ds\t%ds\t%s", channel.id(), stateFor, age, channel.attr(CHANNEL_URI).get()));
            }
            this.logger.info("Active channels: " + this.channelCount.get() + " Leaked channels: " + (this.channelCount.get() - this.leased.size() - this.available.size()));
        }
    }

    private static class ChannelRequest {
        private URI destinationURI;
        private URI channelURI;
        private Proxy proxy;
        private Promise<Channel> promise;

        private ChannelRequest() {
        }
    }
}

