/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl.driver;

import com.microsoft.playwright.impl.driver.DriverLogging;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Driver {
    protected final Map<String, String> env = new LinkedHashMap<String, String>();
    public static final String PLAYWRIGHT_NODEJS_PATH = "PLAYWRIGHT_NODEJS_PATH";
    private static Driver instance;

    public static synchronized Driver ensureDriverInstalled(Map<String, String> env, Boolean installBrowsers) {
        if (instance == null) {
            instance = Driver.createAndInstall(env, installBrowsers);
        }
        return instance;
    }

    private void initialize(Map<String, String> env, Boolean installBrowsers) throws Exception {
        this.env.putAll(env);
        this.initialize(installBrowsers);
    }

    protected abstract void initialize(Boolean var1) throws Exception;

    public ProcessBuilder createProcessBuilder() {
        String nodePath = this.env.get(PLAYWRIGHT_NODEJS_PATH);
        if (nodePath == null) {
            String node = System.getProperty("os.name").toLowerCase().contains("windows") ? "node.exe" : "node";
            nodePath = this.driverDir().resolve(node).toAbsolutePath().toString();
        }
        ProcessBuilder pb = new ProcessBuilder(nodePath);
        pb.command().add(this.driverDir().resolve("package").resolve("cli.js").toAbsolutePath().toString());
        pb.environment().putAll(this.env);
        pb.environment().put("PW_LANG_NAME", "java");
        pb.environment().put("PW_LANG_NAME_VERSION", Driver.getMajorJavaVersion());
        String version = Driver.class.getPackage().getImplementationVersion();
        if (version != null) {
            pb.environment().put("PW_CLI_DISPLAY_VERSION", version);
        }
        return pb;
    }

    private static String getMajorJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            return version.substring(2, 3);
        }
        int dot = version.indexOf(".");
        if (dot != -1) {
            return version.substring(0, dot);
        }
        return version;
    }

    public static Driver createAndInstall(Map<String, String> env, Boolean installBrowsers) {
        try {
            Driver instance = Driver.newInstance();
            Driver.logMessage("initializing driver");
            instance.initialize(env, installBrowsers);
            Driver.logMessage("driver initialized.");
            return instance;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create driver", exception);
        }
    }

    private static Driver newInstance() throws Exception {
        String pathFromProperty = System.getProperty("playwright.cli.dir");
        if (pathFromProperty != null) {
            return new PreinstalledDriver(Paths.get(pathFromProperty, new String[0]));
        }
        String driverImpl = System.getProperty("playwright.driver.impl", "com.microsoft.playwright.impl.driver.jar.DriverJar");
        Class<?> jarDriver = Class.forName(driverImpl);
        return (Driver)jarDriver.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public abstract Path driverDir();

    protected static void logMessage(String message) {
        DriverLogging.logWithTimestamp("pw:install " + message);
    }

    private static class PreinstalledDriver
    extends Driver {
        private final Path driverDir;

        PreinstalledDriver(Path driverDir) {
            PreinstalledDriver.logMessage("created PreinstalledDriver: " + driverDir);
            this.driverDir = driverDir;
        }

        @Override
        protected void initialize(Boolean installBrowsers) {
        }

        @Override
        public Path driverDir() {
            return this.driverDir;
        }
    }
}

