/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.PlaywrightException;
import com.microsoft.playwright.impl.Driver;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;

public class DriverJar
extends Driver {
    private final Path driverTempDir = Files.createTempDirectory("playwright-java-", new FileAttribute[0]);

    DriverJar() throws IOException, URISyntaxException, InterruptedException {
        this.driverTempDir.toFile().deleteOnExit();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        Path path = Paths.get(classloader.getResource("driver").toURI());
        Files.list(path).forEach(filePath -> {
            try {
                DriverJar.extractResource(filePath, this.driverTempDir);
            }
            catch (IOException e) {
                throw new PlaywrightException("Failed to extract driver from " + path, (Throwable)e);
            }
        });
        Path driver = this.driverTempDir.resolve("playwright-cli");
        ProcessBuilder pb = new ProcessBuilder(driver.toString(), "install");
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Process p = pb.start();
        boolean result = p.waitFor(10L, TimeUnit.MINUTES);
        if (!result) {
            System.err.println("Timed out waiting for browsers to install");
        }
    }

    private static Path extractResource(Path from, Path toDir) throws IOException {
        Path path = toDir.resolve(from.getFileName());
        Files.copy(from, path, new CopyOption[0]);
        path.toFile().setExecutable(true);
        path.toFile().deleteOnExit();
        return path;
    }

    Path driverDir() {
        return this.driverTempDir;
    }
}

