/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.tools.Element;
import com.microsoft.playwright.tools.Event;
import com.microsoft.playwright.tools.Method;
import com.microsoft.playwright.tools.TypeDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Interface
extends TypeDefinition {
    private final List<Method> methods = new ArrayList<Method>();
    private final List<Event> events = new ArrayList<Event>();
    private static String header = "/*\n * Copyright (c) Microsoft Corporation.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\npackage com.microsoft.playwright;\n";
    private static Set<String> allowedBaseInterfaces = new HashSet<String>(Arrays.asList("Browser", "JSHandle", "BrowserContext"));

    Interface(JsonObject jsonElement) {
        super(null, jsonElement);
        for (Map.Entry m : jsonElement.get("methods").getAsJsonObject().entrySet()) {
            this.methods.add(new Method(this, ((JsonElement)m.getValue()).getAsJsonObject()));
        }
        for (Map.Entry m : jsonElement.get("properties").getAsJsonObject().entrySet()) {
            this.methods.add(new Method(this, ((JsonElement)m.getValue()).getAsJsonObject()));
        }
        for (Map.Entry m : jsonElement.get("events").getAsJsonObject().entrySet()) {
            this.events.add(new Event((Element)this, ((JsonElement)m.getValue()).getAsJsonObject()));
        }
    }

    @Override
    void writeTo(List<String> output, String offset) {
        String base;
        output.add(header);
        if (this.jsonName.equals("Route")) {
            output.add("import java.nio.charset.StandardCharsets;");
        }
        if ("Download".equals(this.jsonName)) {
            output.add("import java.io.InputStream;");
        }
        if (Arrays.asList("Page", "Frame", "ElementHandle", "FileChooser", "Browser", "BrowserContext", "BrowserType", "Download", "Route", "Selectors").contains(this.jsonName)) {
            output.add("import java.nio.file.Path;");
        }
        output.add("import java.util.*;");
        if (Arrays.asList("Page", "BrowserContext").contains(this.jsonName)) {
            output.add("import java.util.function.Consumer;");
        }
        if (Arrays.asList("Page", "Frame", "BrowserContext", "WebSocket").contains(this.jsonName)) {
            output.add("import java.util.function.Predicate;");
        }
        if (Arrays.asList("Page", "Frame", "BrowserContext").contains(this.jsonName)) {
            output.add("import java.util.regex.Pattern;");
        }
        output.add("");
        String implementsClause = "";
        if (this.jsonElement.getAsJsonObject().has("extends") && allowedBaseInterfaces.contains(base = this.jsonElement.getAsJsonObject().get("extends").getAsString())) {
            implementsClause = " extends " + base;
        }
        this.writeJavadoc(output, offset, this.formattedComment());
        output.add("public interface " + this.jsonName + implementsClause + " {");
        offset = "  ";
        this.writeSharedTypes(output, offset);
        this.writeEvents(output, offset);
        super.writeTo(output, offset);
        for (Method m : this.methods) {
            m.writeTo(output, offset);
        }
        if ("Worker".equals(this.jsonName)) {
            output.add(offset + "Deferred<Event<EventType>> waitForEvent(EventType event);");
        }
        output.add("}");
        output.add("\n");
    }

    private void writeEvents(List<String> output, String offset) {
        if (this.events.isEmpty()) {
            return;
        }
        output.add(offset + "enum EventType {");
        for (int i = 0; i < this.events.size(); ++i) {
            String comma = i == this.events.size() ? "" : ",";
            output.add(offset + "  " + this.events.get((int)i).jsonName.toUpperCase() + comma);
        }
        output.add(offset + "}");
        output.add("");
        output.add(offset + "void addListener(EventType type, Listener<EventType> listener);");
        output.add(offset + "void removeListener(EventType type, Listener<EventType> listener);");
    }

    private void writeSharedTypes(List<String> output, String offset) {
        switch (this.jsonName) {
            case "Dialog": {
                output.add(offset + "enum Type { ALERT, BEFOREUNLOAD, CONFIRM, PROMPT }");
                output.add("");
                break;
            }
            case "Mouse": {
                output.add(offset + "enum Button { LEFT, MIDDLE, RIGHT }");
                output.add("");
                break;
            }
            case "Keyboard": {
                output.add(offset + "enum Modifier { ALT, CONTROL, META, SHIFT }");
                output.add("");
                break;
            }
            case "Page": {
                output.add(offset + "class Viewport {");
                output.add(offset + "  private final int width;");
                output.add(offset + "  private final int height;");
                output.add("");
                output.add(offset + "  public Viewport(int width, int height) {");
                output.add(offset + "    this.width = width;");
                output.add(offset + "    this.height = height;");
                output.add(offset + "  }");
                output.add("");
                output.add(offset + "  public int width() {");
                output.add(offset + "    return width;");
                output.add(offset + "  }");
                output.add("");
                output.add(offset + "  public int height() {");
                output.add(offset + "    return height;");
                output.add(offset + "  }");
                output.add(offset + "}");
                output.add("");
                output.add(offset + "interface Function {");
                output.add(offset + "  Object call(Object... args);");
                output.add(offset + "}");
                output.add("");
                output.add(offset + "interface Binding {");
                output.add(offset + "  interface Source {");
                output.add(offset + "    BrowserContext context();");
                output.add(offset + "    Page page();");
                output.add(offset + "    Frame frame();");
                output.add(offset + "  }");
                output.add("");
                output.add(offset + "  Object call(Source source, Object... args);");
                output.add(offset + "}");
                output.add("");
                output.add(offset + "interface Error {");
                output.add(offset + "  String message();");
                output.add(offset + "  String name();");
                output.add(offset + "  String stack();");
                output.add(offset + "}");
                output.add("");
                break;
            }
            case "BrowserContext": {
                output.add(offset + "enum SameSite { STRICT, LAX, NONE }");
                output.add("");
                output.add(offset + "class HTTPCredentials {");
                output.add(offset + "  private final String username;");
                output.add(offset + "  private final String password;");
                output.add("");
                output.add(offset + "  public HTTPCredentials(String username, String password) {");
                output.add(offset + "    this.username = username;");
                output.add(offset + "    this.password = password;");
                output.add(offset + "  }");
                output.add("");
                output.add(offset + "  public String username() {");
                output.add(offset + "    return username;");
                output.add(offset + "  }");
                output.add("");
                output.add(offset + "  public String password() {");
                output.add(offset + "    return password;");
                output.add(offset + "  }");
                output.add(offset + "}");
                output.add("");
                output.add(offset + "class StorageState {");
                output.add(offset + "  public List<AddCookie> cookies;");
                output.add(offset + "  public List<OriginState> origins;");
                output.add("");
                output.add(offset + "  public static class OriginState {");
                output.add(offset + "    public final String origin;");
                output.add(offset + "    public List<LocalStorageItem> localStorage;");
                output.add("");
                output.add(offset + "    public static class LocalStorageItem {");
                output.add(offset + "      public String name;");
                output.add(offset + "      public String value;");
                output.add(offset + "      public LocalStorageItem(String name, String value) {");
                output.add(offset + "        this.name = name;");
                output.add(offset + "        this.value = value;");
                output.add(offset + "      }");
                output.add(offset + "    }");
                output.add("");
                output.add(offset + "    public OriginState(String origin) {");
                output.add(offset + "      this.origin = origin;");
                output.add(offset + "    }");
                output.add("");
                output.add(offset + "    public OriginState withLocalStorage(List<LocalStorageItem> localStorage) {");
                output.add(offset + "      this.localStorage = localStorage;");
                output.add(offset + "      return this;");
                output.add(offset + "    }");
                output.add(offset + "  }");
                output.add("");
                output.add(offset + "  public StorageState() {");
                output.add(offset + "    cookies = new ArrayList<>();");
                output.add(offset + "    origins = new ArrayList<>();");
                output.add(offset + "  }");
                output.add("");
                output.add(offset + "  public List<AddCookie> cookies() {");
                output.add(offset + "    return this.cookies;");
                output.add(offset + "  }");
                output.add(offset + "  public List<OriginState> origins() {");
                output.add(offset + "    return this.origins;");
                output.add(offset + "  }");
                output.add(offset + "}");
                output.add("");
                break;
            }
            case "Browser": {
                output.add(offset + "class VideoSize {");
                output.add(offset + "  private final int width;");
                output.add(offset + "  private final int height;");
                output.add("");
                output.add(offset + "  public VideoSize(int width, int height) {");
                output.add(offset + "    this.width = width;");
                output.add(offset + "    this.height = height;");
                output.add(offset + "  }");
                output.add("");
                output.add(offset + "  public int width() {");
                output.add(offset + "    return width;");
                output.add(offset + "  }");
                output.add("");
                output.add(offset + "  public int height() {");
                output.add(offset + "    return height;");
                output.add(offset + "  }");
                output.add(offset + "}");
                output.add("");
                break;
            }
            case "ElementHandle": {
                output.add(offset + "class BoundingBox {");
                output.add(offset + "  public double x;");
                output.add(offset + "  public double y;");
                output.add(offset + "  public double width;");
                output.add(offset + "  public double height;");
                output.add(offset + "}");
                output.add("");
                output.add(offset + "class SelectOption {");
                output.add(offset + "  public String value;");
                output.add(offset + "  public String label;");
                output.add(offset + "  public Integer index;");
                output.add("");
                output.add(offset + "  public SelectOption withValue(String value) {");
                output.add(offset + "    this.value = value;");
                output.add(offset + "    return this;");
                output.add(offset + "  }");
                output.add(offset + "  public SelectOption withLabel(String label) {");
                output.add(offset + "    this.label = label;");
                output.add(offset + "    return this;");
                output.add(offset + "  }");
                output.add(offset + "  public SelectOption withIndex(int index) {");
                output.add(offset + "    this.index = index;");
                output.add(offset + "    return this;");
                output.add(offset + "  }");
                output.add(offset + "}");
                output.add("");
                break;
            }
            case "FileChooser": {
                output.add(offset + "class FilePayload {");
                output.add(offset + "  public final String name;");
                output.add(offset + "  public final String mimeType;");
                output.add(offset + "  public final byte[] buffer;");
                output.add("");
                output.add(offset + "  public FilePayload(String name, String mimeType, byte[] buffer) {");
                output.add(offset + "    this.name = name;");
                output.add(offset + "    this.mimeType = mimeType;");
                output.add(offset + "    this.buffer = buffer;");
                output.add(offset + "  }");
                output.add(offset + "}");
                output.add("");
                break;
            }
            case "WebSocket": {
                output.add(offset + "interface FrameData {");
                output.add(offset + "  byte[] body();");
                output.add(offset + "  String text();");
                output.add(offset + "}");
                output.add("");
            }
        }
        if (Arrays.asList("Page", "BrowserContext", "WebSocket").contains(this.jsonName)) {
            output.add(offset + "class WaitForEventOptions {");
            output.add(offset + "  public Integer timeout;");
            output.add(offset + "  public Predicate<Event<EventType>> predicate;");
            output.add(offset + "  public WaitForEventOptions withTimeout(int millis) {");
            output.add(offset + "    timeout = millis;");
            output.add(offset + "    return this;");
            output.add(offset + "  }");
            output.add(offset + "  public WaitForEventOptions withPredicate(Predicate<Event<EventType>> predicate) {");
            output.add(offset + "    this.predicate = predicate;");
            output.add(offset + "    return this;");
            output.add(offset + "  }");
            output.add(offset + "}");
            output.add("");
        }
    }
}

