/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.tools.Element;
import com.microsoft.playwright.tools.Enum;
import com.microsoft.playwright.tools.NestedClass;
import com.microsoft.playwright.tools.Types;
import java.util.ArrayList;
import java.util.List;

abstract class TypeDefinition
extends Element {
    final List<Enum> enums = new ArrayList<Enum>();
    final List<NestedClass> classes = new ArrayList<NestedClass>();
    static final Types types = new Types();

    TypeDefinition(Element parent, JsonObject jsonElement) {
        super(parent, (JsonElement)jsonElement);
    }

    TypeDefinition(Element parent, boolean useParentJsonPath, JsonObject jsonElement) {
        super(parent, useParentJsonPath, (JsonElement)jsonElement);
    }

    @Override
    TypeDefinition typeScope() {
        return this;
    }

    void createEnum(String name, String values) {
        this.addEnum(new Enum(this, name, values));
    }

    void addEnum(Enum newEnum) {
        for (Enum e : this.enums) {
            if (!e.name.equals(newEnum.name)) continue;
            return;
        }
        this.enums.add(newEnum);
    }

    void createNestedClass(String name, Element parent, JsonObject jsonObject) {
        for (NestedClass c : this.classes) {
            if (!c.name.equals(name)) continue;
            return;
        }
        this.classes.add(new NestedClass(parent, name, jsonObject));
    }

    void writeTo(List<String> output, String offset) {
        for (Enum e : this.enums) {
            e.writeTo(output, offset);
        }
        for (NestedClass c : this.classes) {
            c.writeTo(output, offset);
        }
    }
}

