/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.tools.Element;
import com.microsoft.playwright.tools.Field;
import com.microsoft.playwright.tools.Method;
import com.microsoft.playwright.tools.TypeDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class NestedClass
extends TypeDefinition {
    final String name;
    final List<Field> fields = new ArrayList<Field>();
    private static Set<String> deprecatedOptions = new HashSet<String>();

    NestedClass(Element parent, String name, JsonObject jsonElement) {
        super(parent, true, jsonElement);
        this.name = name;
        if (jsonElement.has("properties")) {
            JsonObject properties = jsonElement.get("properties").getAsJsonObject();
            for (Map.Entry m : properties.entrySet()) {
                if (deprecatedOptions.contains(this.jsonPath + "." + (String)m.getKey())) continue;
                this.fields.add(new Field(this, (String)m.getKey(), ((JsonElement)m.getValue()).getAsJsonObject()));
            }
        }
    }

    @Override
    void writeTo(List<String> output, String offset) {
        String access = this.parent.typeScope() instanceof NestedClass ? "public " : "";
        output.add(offset + access + "class " + this.name + " {");
        String bodyOffset = offset + "  ";
        super.writeTo(output, bodyOffset);
        boolean isReturnType = this.parent.parent instanceof Method;
        String fieldAccess = isReturnType ? "private " : "public ";
        for (Field f : this.fields) {
            f.writeTo(output, bodyOffset, fieldAccess);
        }
        output.add("");
        if ("Request.failure".equals(this.jsonPath)) {
            this.writeConstructor(output, bodyOffset);
        }
        if (isReturnType) {
            for (Field f : this.fields) {
                f.writeGetter(output, bodyOffset);
            }
        } else {
            this.writeBuilderMethods(output, bodyOffset);
        }
        output.add(offset + "}");
    }

    private void writeBuilderMethods(List<String> output, String bodyOffset) {
        if (this.parent.typeScope() instanceof NestedClass) {
            NestedClass outer = (NestedClass)this.parent.typeScope();
            output.add(bodyOffset + this.name + "() {");
            output.add(bodyOffset + "}");
            output.add(bodyOffset + "public " + outer.name + " done() {");
            output.add(bodyOffset + "  return " + outer.name + ".this;");
            output.add(bodyOffset + "}");
            output.add("");
        }
        for (Field f : this.fields) {
            f.writeBuilderMethod(output, bodyOffset, this.name);
        }
    }

    private void writeConstructor(List<String> output, String bodyOffset) {
        ArrayList<String> args = new ArrayList<String>();
        for (Field f : this.fields) {
            args.add(f.type.toJava() + " " + f.name);
        }
        output.add(bodyOffset + "public " + this.name + "(" + String.join((CharSequence)", ", args) + ") {");
        for (Field f : this.fields) {
            output.add(bodyOffset + "  this." + f.name + " = " + f.name + ";");
        }
        output.add(bodyOffset + "}");
    }

    static {
        deprecatedOptions.add("Browser.newPage.options.videosPath");
        deprecatedOptions.add("Browser.newPage.options.videoSize");
        deprecatedOptions.add("Browser.newContext.options.videosPath");
        deprecatedOptions.add("Browser.newContext.options.videoSize");
        deprecatedOptions.add("BrowserType.launchPersistentContext.options.videosPath");
        deprecatedOptions.add("BrowserType.launchPersistentContext.options.videoSize");
    }
}

