/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.tools;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.tools.Interface;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ApiGenerator {
    private static Set<String> skipList = new HashSet<String>(Arrays.asList("BrowserServer", "ChromiumBrowser", "ChromiumBrowserContext", "ChromiumCoverage", "CDPSession", "FirefoxBrowser", "WebKitBrowser"));

    ApiGenerator(Reader reader) throws IOException {
        JsonObject api = (JsonObject)new Gson().fromJson(reader, JsonObject.class);
        File cwd = FileSystems.getDefault().getPath(".", new String[0]).toFile();
        File dir = new File(cwd, "playwright/src/main/java/com/microsoft/playwright");
        System.out.println("Writing files to: " + dir.getCanonicalPath());
        for (Map.Entry entry : api.entrySet()) {
            String name = (String)entry.getKey();
            if (skipList.contains(name)) continue;
            ArrayList<String> lines = new ArrayList<String>();
            new Interface(((JsonElement)entry.getValue()).getAsJsonObject()).writeTo(lines, "");
            String text = String.join((CharSequence)"\n", lines);
            FileWriter writer = new FileWriter(new File(dir, name + ".java"));
            writer.write(text);
            writer.close();
        }
    }

    public static void main(String[] args) throws IOException {
        File cwd = FileSystems.getDefault().getPath(".", new String[0]).toFile();
        System.out.println(cwd.getCanonicalPath());
        File file = new File(cwd, "api-generator/src/main/resources/api.json");
        System.out.println("Reading from: " + file.getCanonicalPath());
        new ApiGenerator(new FileReader(file));
    }
}

