/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.tools.TypeDefinition;
import java.util.List;

abstract class Element {
    final String jsonName;
    final String jsonPath;
    final JsonElement jsonElement;
    final Element parent;

    Element(Element parent, JsonElement jsonElement) {
        this(parent, false, jsonElement);
    }

    Element(Element parent, boolean useParentJsonPath, JsonElement jsonElement) {
        this.parent = parent;
        this.jsonName = jsonElement != null && jsonElement.isJsonObject() ? jsonElement.getAsJsonObject().get("name").getAsString() : "";
        this.jsonPath = useParentJsonPath ? parent.jsonPath : (parent == null ? this.jsonName : parent.jsonPath + "." + this.jsonName);
        this.jsonElement = jsonElement;
    }

    TypeDefinition typeScope() {
        return this.parent.typeScope();
    }

    static String toTitle(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    void writeJavadoc(List<String> output, String offset, String text) {
        String[] lines;
        if (text.isEmpty()) {
            return;
        }
        output.add(offset + "/**");
        for (String line : lines = text.split("\\n")) {
            output.add(offset + " * " + line.replace("*/", "*\\/").replace("**NOTE**", "<strong>NOTE</strong>").replaceAll("`([^`]+)`", "{@code $1}"));
        }
        output.add(offset + " */");
    }

    String formattedComment() {
        return this.comment().replaceAll("```((?<!`)`(?!`)|[^`])+```", "").replaceAll("\\nAn example of[^\\n]+\\n", "").replaceAll("\\nThis example [^\\n]+\\n", "").replaceAll("\\nSee ChromiumBrowser[^\\n]+", "\n").replaceAll("\\n\\n", "\n").replaceAll("\\n", "\n<p>\n");
    }

    String comment() {
        JsonObject json = this.jsonElement.getAsJsonObject();
        if (!json.has("comment")) {
            return "";
        }
        return json.get("comment").getAsString();
    }
}

