/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http;

import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.authentication.BaseBearerTokenAuthenticationProvider;
import com.microsoft.kiota.http.middleware.AuthorizationHandler;
import com.microsoft.kiota.http.middleware.HeadersInspectionHandler;
import com.microsoft.kiota.http.middleware.ParametersNameDecodingHandler;
import com.microsoft.kiota.http.middleware.RedirectHandler;
import com.microsoft.kiota.http.middleware.RetryHandler;
import com.microsoft.kiota.http.middleware.UrlReplaceHandler;
import com.microsoft.kiota.http.middleware.UserAgentHandler;
import com.microsoft.kiota.http.middleware.options.HeadersInspectionOption;
import com.microsoft.kiota.http.middleware.options.ParametersNameDecodingOption;
import com.microsoft.kiota.http.middleware.options.RedirectHandlerOption;
import com.microsoft.kiota.http.middleware.options.RetryHandlerOption;
import com.microsoft.kiota.http.middleware.options.UrlReplaceHandlerOption;
import com.microsoft.kiota.http.middleware.options.UserAgentHandlerOption;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class KiotaClientFactory {
    private KiotaClientFactory() {
    }

    @Nonnull
    public static OkHttpClient.Builder create() {
        return KiotaClientFactory.create(KiotaClientFactory.createDefaultInterceptors());
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull RequestOption[] requestOptions) {
        Objects.requireNonNull(requestOptions, "parameter requestOptions cannot be null");
        return KiotaClientFactory.create(KiotaClientFactory.createDefaultInterceptors(requestOptions));
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull Interceptor[] interceptors) {
        Objects.requireNonNull(interceptors, "parameter interceptors cannot be null");
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(100L)).readTimeout(Duration.ofSeconds(100L)).callTimeout(Duration.ofSeconds(100L));
        for (Interceptor interceptor : interceptors) {
            builder.addInterceptor(interceptor);
        }
        return builder;
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull List<Interceptor> interceptors) {
        Objects.requireNonNull(interceptors, "parameter interceptors cannot be null");
        return KiotaClientFactory.create(new ArrayList<Interceptor>(interceptors).toArray(new Interceptor[0]));
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull BaseBearerTokenAuthenticationProvider authenticationProvider) {
        return KiotaClientFactory.create(authenticationProvider, new RequestOption[0]);
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull BaseBearerTokenAuthenticationProvider authenticationProvider, @Nonnull RequestOption[] requestOptions) {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(Arrays.asList(KiotaClientFactory.createDefaultInterceptors(requestOptions)));
        interceptors.add(new AuthorizationHandler(authenticationProvider));
        return KiotaClientFactory.create(interceptors);
    }

    @Nonnull
    public static Interceptor[] createDefaultInterceptors() {
        return KiotaClientFactory.createDefaultInterceptors(new RequestOption[0]);
    }

    @Nonnull
    public static Interceptor[] createDefaultInterceptors(@Nonnull RequestOption[] requestOptions) {
        Objects.requireNonNull(requestOptions, "parameter requestOptions cannot be null");
        UrlReplaceHandlerOption uriReplacementOption = null;
        UserAgentHandlerOption userAgentHandlerOption = null;
        RetryHandlerOption retryHandlerOption = null;
        RedirectHandlerOption redirectHandlerOption = null;
        ParametersNameDecodingOption parametersNameDecodingOption = null;
        HeadersInspectionOption headersInspectionHandlerOption = null;
        for (RequestOption option : requestOptions) {
            if (uriReplacementOption == null && option instanceof UrlReplaceHandlerOption) {
                uriReplacementOption = (UrlReplaceHandlerOption)option;
                continue;
            }
            if (retryHandlerOption == null && option instanceof RetryHandlerOption) {
                retryHandlerOption = (RetryHandlerOption)option;
                continue;
            }
            if (redirectHandlerOption == null && option instanceof RedirectHandlerOption) {
                redirectHandlerOption = (RedirectHandlerOption)option;
                continue;
            }
            if (parametersNameDecodingOption == null && option instanceof ParametersNameDecodingOption) {
                parametersNameDecodingOption = (ParametersNameDecodingOption)option;
                continue;
            }
            if (userAgentHandlerOption == null && option instanceof UserAgentHandlerOption) {
                userAgentHandlerOption = (UserAgentHandlerOption)option;
                continue;
            }
            if (headersInspectionHandlerOption != null || !(option instanceof HeadersInspectionOption)) continue;
            headersInspectionHandlerOption = (HeadersInspectionOption)option;
        }
        ArrayList<Object> handlers = new ArrayList<Object>();
        handlers.add(userAgentHandlerOption != null ? new UserAgentHandler(userAgentHandlerOption) : new UserAgentHandler());
        handlers.add(parametersNameDecodingOption != null ? new ParametersNameDecodingHandler(parametersNameDecodingOption) : new ParametersNameDecodingHandler());
        handlers.add(uriReplacementOption != null ? new UrlReplaceHandler(uriReplacementOption) : new UrlReplaceHandler());
        handlers.add(headersInspectionHandlerOption != null ? new HeadersInspectionHandler(headersInspectionHandlerOption) : new HeadersInspectionHandler());
        handlers.add(redirectHandlerOption != null ? new RedirectHandler(redirectHandlerOption) : new RedirectHandler());
        handlers.add(retryHandlerOption != null ? new RetryHandler(retryHandlerOption) : new RetryHandler());
        return handlers.toArray(new Interceptor[0]);
    }

    @Deprecated
    @Nonnull
    public static List<Interceptor> createDefaultInterceptorsAsList() {
        return new ArrayList<Interceptor>(Arrays.asList(KiotaClientFactory.createDefaultInterceptors()));
    }
}

