/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util.ported;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public enum LocalBroadcaster {
    INSTANCE;

    private static final String TAG;
    private static ExecutorService sBroadcastExecutor;
    final ConcurrentHashMap<String, IReceiverCallback> mReceivers = new ConcurrentHashMap();

    public void registerCallback(@NonNull String alias, @NonNull IReceiverCallback callback) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        String methodName = ":registerCallback";
        if (this.mReceivers.containsKey(alias)) {
            Logger.warn(TAG + ":registerCallback", "The alias: " + alias + " has already been registered. It will be overwritten");
        }
        Logger.info(TAG + ":registerCallback", "Registering alias: " + alias);
        this.mReceivers.put(alias, callback);
    }

    public void unregisterCallback(@NonNull String alias) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        String methodName = ":unregisterCallback";
        Logger.info(TAG + ":unregisterCallback", "Removing alias: " + alias);
        this.mReceivers.remove(alias);
    }

    public boolean hasReceivers(@NonNull String alias) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        return this.mReceivers.containsKey(alias);
    }

    public void broadcast(final @NonNull String alias, final @NonNull PropertyBag propertyBag) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        if (propertyBag == null) {
            throw new NullPointerException("propertyBag is marked non-null but is null");
        }
        String methodName = ":broadcast";
        sBroadcastExecutor.execute(new Runnable(){

            @Override
            public void run() {
                IReceiverCallback receiver = LocalBroadcaster.this.mReceivers.get(alias);
                if (receiver != null) {
                    Logger.info(TAG + ":broadcast", "broadcasting to alias: " + alias);
                    receiver.onReceive(propertyBag);
                } else {
                    Logger.info(TAG + ":broadcast", "No callback is registered with alias: " + alias + ". Do nothing.");
                }
            }
        });
    }

    public void clearReceivers() {
        this.mReceivers.clear();
    }

    public static void resetBroadcast() {
        LocalBroadcaster.shutdownAndAwaitTerminationForBroadcasterService();
        sBroadcastExecutor = Executors.newSingleThreadExecutor();
    }

    private static void shutdownAndAwaitTerminationForBroadcasterService() {
        String methodName = ":shutdownAndAwaitTerminationForBroadcasterService";
        sBroadcastExecutor.shutdown();
        try {
            if (!sBroadcastExecutor.awaitTermination(20L, TimeUnit.SECONDS)) {
                sBroadcastExecutor.shutdownNow();
                if (!sBroadcastExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    Logger.info(TAG + ":shutdownAndAwaitTerminationForBroadcasterService", "broadcastExecutor did not terminate");
                }
            }
        }
        catch (InterruptedException ex) {
            sBroadcastExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        TAG = LocalBroadcaster.class.getSimpleName();
        sBroadcastExecutor = Executors.newSingleThreadExecutor();
    }

    public static interface IReceiverCallback {
        public void onReceive(@NonNull PropertyBag var1);
    }
}

