/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util.ported;

import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.util.ported.Predicate;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class InMemoryStorage<T>
implements INameValueStorage<T> {
    private final Map<String, T> mMap = new ConcurrentHashMap<String, T>();

    @Override
    @Nullable
    public T get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.mMap.get(key);
    }

    @Override
    @NonNull
    public Map<String, T> getAll() {
        return this.mMap;
    }

    @Override
    public void put(@NonNull String key, @Nullable T value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            this.mMap.remove(key);
            return;
        }
        this.mMap.put(key, value);
    }

    @Override
    public void remove(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.mMap.remove(name);
    }

    @Override
    public void clear() {
        this.mMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.mMap.keySet();
    }

    @Override
    public Iterator<Map.Entry<String, T>> getAllFilteredByKey(Predicate<String> keyFilter) {
        HashMap<String, T> newMap = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : this.mMap.entrySet()) {
            if (!keyFilter.test(entry.getKey())) continue;
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap.entrySet().iterator();
    }

    public int size() {
        return this.mMap.size();
    }
}

