/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.util;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.challengehandlers.IDeviceCertificate;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.cert.CertificateEncodingException;
import lombok.NonNull;

public class JWSBuilder {
    protected static final long SECONDS_MS = 1000L;
    protected static final String JWS_HEADER_ALG = "RS256";
    private static final String SIGNING_ALGORITHM = "SHA256withRSA";
    private static final String TAG = "JWSBuilder";

    protected long getCurrentTimeInSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    protected String encodeUrlSafeString(byte[] dataToEncode) {
        return StringUtil.encodeUrlSafeString(dataToEncode);
    }

    public String generateSignedJWT(@NonNull String nonce, @NonNull String audience, @NonNull IDeviceCertificate deviceCert) throws ClientException {
        String signature;
        String signingInput;
        if (nonce == null) {
            throw new NullPointerException("nonce is marked non-null but is null");
        }
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        if (deviceCert == null) {
            throw new NullPointerException("deviceCert is marked non-null but is null");
        }
        String methodTag = "JWSBuilder:generateSignedJWT";
        if (nonce.isEmpty()) {
            throw new IllegalArgumentException("nonce is an empty string.");
        }
        if (audience.isEmpty()) {
            throw new IllegalArgumentException("audience is an empty string.");
        }
        Gson gson = new Gson();
        Claims claims = new Claims();
        claims.mNonce = nonce;
        claims.mAudience = audience;
        claims.mIssueAt = this.getCurrentTimeInSeconds();
        JwsHeader header = new JwsHeader();
        header.mAlgorithm = JWS_HEADER_ALG;
        header.mType = "JWT";
        try {
            JwsHeader.access$702(header, new String[1]);
            ((JwsHeader)header).mCert[0] = StringUtil.base64Encode(deviceCert.getX509().getEncoded());
            String headerJsonString = gson.toJson((Object)header);
            String claimsJsonString = gson.toJson((Object)claims);
            Logger.verbose("JWSBuilder:generateSignedJWT", "Generate client certificate challenge response JWS Header. ");
            signingInput = this.encodeUrlSafeString(StringUtil.toByteArray(headerJsonString)) + "." + this.encodeUrlSafeString(StringUtil.toByteArray(claimsJsonString));
            signature = this.encodeUrlSafeString(deviceCert.sign(SIGNING_ALGORITHM, StringUtil.toByteArray(signingInput)));
        }
        catch (CertificateEncodingException e) {
            throw new ClientException("Certificate encoding is not generated", "Certificate encoding error", e);
        }
        return signingInput + "." + signature;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    static final class JwsHeader {
        @SerializedName(value="alg")
        private String mAlgorithm;
        @SerializedName(value="typ")
        private String mType;
        @SerializedName(value="x5c")
        private String[] mCert;

        private JwsHeader() {
        }

        static /* synthetic */ String[] access$702(JwsHeader x0, String[] x1) {
            x0.mCert = x1;
            return x1;
        }
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    static final class Claims {
        @SerializedName(value="aud")
        private String mAudience;
        @SerializedName(value="iat")
        private long mIssueAt;
        @SerializedName(value="nonce")
        private String mNonce;

        private Claims() {
        }
    }
}

