/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.telemetry.events;

import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;

@Deprecated
public class ErrorEvent
extends BaseEvent {
    public static final String ERROR_TAG_PREFIX = "tag_";

    public ErrorEvent() {
        this.types("Microsoft.MSAL.error_event");
    }

    private String generateErrorTag(Exception exception, StackTraceElement stackTraceElement) {
        String tag = exception.getClass().getSimpleName() + exception.getMessage() + stackTraceElement.getClassName() + stackTraceElement.getMethodName();
        if (exception instanceof BaseException) {
            tag = tag + ((BaseException)exception).getErrorCode();
        }
        return ERROR_TAG_PREFIX + ((long)tag.hashCode() + Integer.MAX_VALUE);
    }

    public ErrorEvent putException(Exception exception) {
        if (exception == null) {
            return this;
        }
        StackTraceElement[] stackTraceElements = exception.getStackTrace();
        if (stackTraceElements != null && stackTraceElements.length > 0) {
            StackTraceElement errorLocation = stackTraceElements[0];
            String errorTag = this.generateErrorTag(exception, errorLocation);
            this.put("Microsoft.MSAL.error_tag", errorTag);
            this.put("Microsoft.MSAL.error_location_class_name", errorLocation.getClassName());
            this.put("Microsoft.MSAL.error_location_line_number", String.valueOf(errorLocation.getLineNumber()));
            this.put("Microsoft.MSAL.error_location_method_name", errorLocation.getMethodName());
        }
        this.put("Microsoft.MSAL.error_class_name", exception.getClass().getSimpleName());
        this.put("Microsoft.MSAL.error_description", exception.getMessage());
        if (exception instanceof BaseException) {
            BaseException adaptedException = (BaseException)exception;
            if (adaptedException.getCause() != null) {
                this.put("Microsoft.MSAL.error_class_name", adaptedException.getCause().getClass().getSimpleName());
            }
            this.put("Microsoft.MSAL.error_code", adaptedException.getErrorCode());
            this.put("Microsoft.MSAL.server_error_code", adaptedException.getCliTelemErrorCode());
            this.put("Microsoft.MSAL.server_sub_error_code", adaptedException.getCliTelemSubErrorCode());
        }
        return this;
    }
}

