/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.telemetry.events;

import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.BrokerSilentTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.util.StringUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import lombok.NonNull;

@Deprecated
public class ApiStartEvent
extends BaseEvent {
    private static final String TAG = ApiStartEvent.class.getSimpleName();

    public ApiStartEvent() {
        this.names("api_start_event");
        this.types("Microsoft.MSAL.api_event");
    }

    public ApiStartEvent(@NonNull String apiId) {
        if (apiId == null) {
            throw new NullPointerException("apiId is marked non-null but is null");
        }
        this.names("api_start_event");
        this.types("Microsoft.MSAL.api_event");
        this.putApiId(apiId);
    }

    @Override
    public ApiStartEvent put(@NonNull String propertyName, String propertyValue) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        super.put(propertyName, propertyValue);
        return this;
    }

    public ApiStartEvent putBrokerVersion(String brokerVersion) {
        this.put("Microsoft.MSAL.broker_version", brokerVersion);
        return this;
    }

    public ApiStartEvent putProperties(@Nullable CommandParameters parameters) {
        SilentTokenCommandParameters silentParameters;
        if (parameters == null) {
            return this;
        }
        if (parameters.getSdkType() != null) {
            this.put("Microsoft.MSAL.sdk_name", parameters.getSdkType().name());
        }
        this.put("Microsoft.MSAL.sdk_version", parameters.getSdkVersion());
        this.put("Microsoft.MSAL.redirect_uri", parameters.getRedirectUri());
        this.put("Microsoft.MSAL.client_id", parameters.getClientId());
        this.put("Microsoft.MSAL.broker_protocol_version", String.valueOf(parameters.getRequiredBrokerProtocolVersion()));
        if (parameters instanceof TokenCommandParameters) {
            AbstractAuthenticationScheme authScheme;
            TokenCommandParameters tokenCommandParameters = (TokenCommandParameters)parameters;
            Authority authority = tokenCommandParameters.getAuthority();
            if (authority != null) {
                if (authority.getAuthorityURL() != null) {
                    this.put("Microsoft.MSAL.authority", authority.getAuthorityURL().getAuthority());
                }
                this.put("Microsoft.MSAL.authority_type", authority.getAuthorityTypeString());
            }
            this.put("Microsoft.MSAL.claim_request", StringUtil.isNullOrEmpty(tokenCommandParameters.getClaimsRequestJson()) ? "false" : "true");
            if (tokenCommandParameters.getScopes() != null) {
                this.put("Microsoft.MSAL.scope_size", String.valueOf(tokenCommandParameters.getScopes().size()));
                this.put("Microsoft.MSAL.scope_value", tokenCommandParameters.getScopes().toString());
            }
            if (null != (authScheme = tokenCommandParameters.getAuthenticationScheme())) {
                this.put("Microsoft.MSAL.authentication_scheme", authScheme.getName());
            }
        }
        if (parameters instanceof InteractiveTokenCommandParameters) {
            InteractiveTokenCommandParameters atOperationParameters = (InteractiveTokenCommandParameters)parameters;
            if (atOperationParameters.getAuthorizationAgent() != null) {
                this.put("Microsoft.MSAL.user_agent", atOperationParameters.getAuthorizationAgent().name());
            }
            this.put("Microsoft.MSAL.login_hint", atOperationParameters.getLoginHint());
            if (atOperationParameters.getExtraQueryStringParameters() != null) {
                this.put("Microsoft.MSAL.query_params", String.valueOf(atOperationParameters.getExtraQueryStringParameters().size()));
            }
            if (atOperationParameters.getPrompt() != null) {
                this.put("Microsoft.MSAL.prompt_behavior", atOperationParameters.getPrompt().toString());
            }
        }
        if (parameters instanceof SilentTokenCommandParameters) {
            silentParameters = (SilentTokenCommandParameters)parameters;
            if (silentParameters.getAccount() != null) {
                this.put("Microsoft.MSAL.user_id", silentParameters.getAccount().getHomeAccountId());
            }
            this.put("Microsoft.MSAL.force_refresh", String.valueOf(silentParameters.isForceRefresh()));
        }
        if (parameters instanceof BrokerInteractiveTokenCommandParameters) {
            BrokerInteractiveTokenCommandParameters interactiveParameters = (BrokerInteractiveTokenCommandParameters)parameters;
            this.put("Microsoft.MSAL.broker_protocol_version", interactiveParameters.getNegotiatedBrokerProtocolVersion());
            this.put("Microsoft.MSAL.caller_app_version", interactiveParameters.getCallerAppVersion());
            this.put("Microsoft.MSAL.caller_app_package_name", interactiveParameters.getCallerPackageName());
            this.put("Microsoft.MSAL.caller_app_uuid", String.valueOf(interactiveParameters.getCallerUid()));
        }
        if (parameters instanceof BrokerSilentTokenCommandParameters) {
            silentParameters = (BrokerSilentTokenCommandParameters)parameters;
            this.put("Microsoft.MSAL.broker_protocol_version", ((BrokerSilentTokenCommandParameters)silentParameters).getNegotiatedBrokerProtocolVersion());
            this.put("Microsoft.MSAL.caller_app_version", ((BrokerSilentTokenCommandParameters)silentParameters).getCallerAppVersion());
            this.put("Microsoft.MSAL.caller_app_package_name", silentParameters.getCallerPackageName());
            this.put("Microsoft.MSAL.caller_app_uuid", String.valueOf(((BrokerSilentTokenCommandParameters)silentParameters).getCallerUid()));
        }
        return this;
    }

    public ApiStartEvent authority(@NonNull String authority) {
        if (authority == null) {
            throw new NullPointerException("authority is marked non-null but is null");
        }
        this.put("Microsoft.MSAL.authority", ApiStartEvent.sanitizeUrlForTelemetry(authority));
        return this;
    }

    public ApiStartEvent putAuthorityType(@NonNull String authorityType) {
        if (authorityType == null) {
            throw new NullPointerException("authorityType is marked non-null but is null");
        }
        this.put("Microsoft.MSAL.authority_type", authorityType);
        return this;
    }

    public ApiStartEvent putApiId(@NonNull String apiId) {
        if (apiId == null) {
            throw new NullPointerException("apiId is marked non-null but is null");
        }
        this.put("Microsoft.MSAL.api_id", apiId);
        return this;
    }

    public ApiStartEvent putValidationStatus(@NonNull String validationStatus) {
        if (validationStatus == null) {
            throw new NullPointerException("validationStatus is marked non-null but is null");
        }
        this.put("Microsoft.MSAL.authority_validation_status", validationStatus);
        return this;
    }

    public ApiStartEvent putWorkPlaceJoined(boolean isWorkPlaceJoined) {
        this.put("Microsoft.MSAL.is_wpj_joined", String.valueOf(isWorkPlaceJoined));
        return this;
    }

    public ApiStartEvent putLoginHint(@NonNull String loginHint) {
        if (loginHint == null) {
            throw new NullPointerException("loginHint is marked non-null but is null");
        }
        String methodTag = TAG + ":putLoginHint";
        try {
            this.put("Microsoft.MSAL.login_hint", StringUtil.createHash(loginHint));
        }
        catch (NoSuchAlgorithmException exception) {
            Logger.warn(methodTag, exception.getMessage());
        }
        return this;
    }

    public ApiStartEvent putExtendedExpiresOnSetting(@NonNull String extendedExpiresOnSetting) {
        if (extendedExpiresOnSetting == null) {
            throw new NullPointerException("extendedExpiresOnSetting is marked non-null but is null");
        }
        this.put("Microsoft.MSAL.extended_expires_on_setting", extendedExpiresOnSetting);
        return this;
    }

    private static String sanitizeUrlForTelemetry(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        URL urlToSanitize = null;
        try {
            urlToSanitize = new URL(url);
        }
        catch (MalformedURLException e1) {
            Logger.errorPII(TAG, "Url is invalid", e1);
        }
        return urlToSanitize == null ? null : ApiStartEvent.sanitizeUrlForTelemetry(urlToSanitize);
    }

    private static String sanitizeUrlForTelemetry(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        String authority = url.getAuthority();
        String[] splitArray = url.getPath().split("/");
        StringBuilder logPath = new StringBuilder();
        logPath.append(url.getProtocol()).append("://").append(authority).append('/');
        for (int i = 2; i < splitArray.length; ++i) {
            logPath.append(splitArray[i]);
            logPath.append('/');
        }
        return logPath.toString();
    }
}

