/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.oauth2;

import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationErrorResponse;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.java.util.UrlUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.util.Map;
import lombok.NonNull;

public abstract class AuthorizationResultFactory<GenericAuthorizationResult extends AuthorizationResult, GenericAuthorizationRequest extends AuthorizationRequest> {
    private static final String TAG = AuthorizationResultFactory.class.getSimpleName();

    public GenericAuthorizationResult createAuthorizationResult(@NonNull RawAuthorizationResult data, @NonNull GenericAuthorizationRequest request) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String methodTag = TAG + ":createAuthorizationResult";
        URI url = data.getAuthorizationFinalUri();
        switch (data.getResultCode()) {
            case CANCELLED: {
                Logger.info(methodTag, null, "The authorization request was intentionally cancelled.");
                return this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.USER_CANCEL, "user_cancelled", "User pressed device back button to cancel the flow.");
            }
            case SDK_CANCELLED: {
                Logger.info(methodTag, null, "SDK cancelled the authorization request.");
                return this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.SDK_CANCEL, "auth_cancelled_by_sdk", "Sdk cancelled the auth flow as the app launched a new interactive auth request.");
            }
            case COMPLETED: {
                if (url == null) {
                    Logger.warn(methodTag, null, "returned URL is null or empty.");
                    return this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "authorization_failed", "The authorization server returned an invalid response.");
                }
                return this.parseRedirectUriAndCreateAuthorizationResult(url, ((AuthorizationRequest)request).getState());
            }
            case NON_OAUTH_ERROR: {
                BaseException exception = data.getException();
                if (exception != null) {
                    return this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, exception.getErrorCode(), exception.getMessage());
                }
            }
            case BROKER_INSTALLATION_TRIGGERED: {
                Logger.info(methodTag, "Device needs to have broker installed, we expect the apps to call usback when the broker is installed");
                GenericAuthorizationResult result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "broker_needs_to_be_installed", "Device needs to have broker installed");
                Map<String, String> urlParameters = UrlUtil.getParameters(url);
                ((AuthorizationErrorResponse)((AuthorizationResult)result).getAuthorizationErrorResponse()).setUpnToWpj(urlParameters.get("username"));
                return result;
            }
            case DEVICE_REGISTRATION_REQUIRED: {
                Logger.info(methodTag, "Device Registration needed, need to start WPJ");
                GenericAuthorizationResult result = this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "device_registration_needed", "Device needs to be registered to access the resource");
                Map<String, String> urlParameters = UrlUtil.getParameters(url);
                ((AuthorizationErrorResponse)((AuthorizationResult)result).getAuthorizationErrorResponse()).setUpnToWpj(urlParameters.get("username"));
                return result;
            }
            case MDM_FLOW: {
                Logger.info(methodTag, "MDM required. Launching Intune MDM link on browser.");
                return this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "device_needs_to_be_managed", "Device needs to be managed to access the resource");
            }
        }
        return this.createAuthorizationResultWithErrorResponse(AuthorizationStatus.FAIL, "Unknown error", "Unknown result code returned [" + (Object)((Object)data.getResultCode()) + "]");
    }

    protected abstract GenericAuthorizationResult parseRedirectUriAndCreateAuthorizationResult(@NonNull URI var1, @Nullable String var2);

    protected abstract GenericAuthorizationResult createAuthorizationResultWithErrorResponse(AuthorizationStatus var1, @NonNull String var2, @Nullable String var3);

    protected abstract GenericAuthorizationResult validateAndCreateAuthorizationResult(@NonNull Map<String, String> var1, @Nullable String var2, @Nullable String var3);
}

