/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory;

import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.java.providers.oauth2.IDToken;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class AzureActiveDirectoryAccount
extends MicrosoftAccount {
    private static final String TAG = AzureActiveDirectoryAccount.class.getSimpleName();
    private String mIdentityProvider;

    public AzureActiveDirectoryAccount() {
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public AzureActiveDirectoryAccount(@NonNull IDToken idToken, @NonNull ClientInfo clientInfo) {
        super(idToken, clientInfo);
        if (idToken == null) {
            throw new NullPointerException("idToken is marked non-null but is null");
        }
        if (clientInfo == null) {
            throw new NullPointerException("clientInfo is marked non-null but is null");
        }
        HashMap claims = new HashMap(idToken.getTokenClaims());
        this.mIdentityProvider = (String)claims.get("idp");
        Logger.verbose(TAG, "Init: " + TAG);
    }

    public synchronized void setIdentityProvider(String idp) {
        this.mIdentityProvider = idp;
    }

    public synchronized String getIdentityProvider() {
        return this.mIdentityProvider;
    }

    @Override
    public String getAuthorityType() {
        return "MSSTS";
    }

    @Override
    protected String getDisplayableIdFromClaims(Map<String, ?> claims) {
        String methodName = "getDisplayableId";
        String displayableId = null;
        if (!StringUtil.isNullOrEmpty((String)claims.get("upn"))) {
            Logger.info(TAG + ":" + "getDisplayableId", "Returning upn as displayableId");
            displayableId = (String)claims.get("upn");
        } else if (!StringUtil.isNullOrEmpty((String)claims.get("email"))) {
            Logger.info(TAG + ":" + "getDisplayableId", "Returning email as displayableId");
            displayableId = (String)claims.get("email");
        }
        return displayableId;
    }

    @Override
    public String toString() {
        return "AzureActiveDirectoryAccount{} " + super.toString() + ", mIdentityProvider='" + this.mIdentityProvider + '\'';
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureActiveDirectoryAccount)) {
            return false;
        }
        AzureActiveDirectoryAccount other = (AzureActiveDirectoryAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mIdentityProvider = this.mIdentityProvider;
        String other$mIdentityProvider = other.mIdentityProvider;
        return !(this$mIdentityProvider == null ? other$mIdentityProvider != null : !this$mIdentityProvider.equals(other$mIdentityProvider));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AzureActiveDirectoryAccount;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mIdentityProvider = this.mIdentityProvider;
        result = result * 59 + ($mIdentityProvider == null ? 43 : $mIdentityProvider.hashCode());
        return result;
    }
}

