/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory;

import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectoryTokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.AccessToken;
import com.microsoft.identity.common.java.util.CopyUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;
import lombok.NonNull;

public class AzureActiveDirectoryAccessToken
extends AccessToken {
    private final Date mExpiresOn;
    private final Date mExtendedExpiresOn;

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public AzureActiveDirectoryAccessToken(@NonNull AzureActiveDirectoryTokenResponse response) {
        super(response);
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.mExpiresOn = CopyUtil.copyIfNotNull(response.getExpiresOn());
        this.mExtendedExpiresOn = CopyUtil.copyIfNotNull(response.getExtExpiresOn());
    }

    public Date getExpiresOn() {
        return CopyUtil.copyIfNotNull(this.mExpiresOn);
    }

    public Date getExtendedExpiresOn() {
        return CopyUtil.copyIfNotNull(this.mExtendedExpiresOn);
    }
}

