/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.microsoft;

import com.microsoft.identity.common.java.BaseAccount;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.java.providers.oauth2.IDToken;
import com.microsoft.identity.common.java.util.CopyUtil;
import com.microsoft.identity.common.java.util.SchemaUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import cz.msebera.android.httpclient.extras.Base64;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public abstract class MicrosoftAccount
extends BaseAccount {
    public static final String AUTHORITY_TYPE_MS_STS = "MSSTS";
    private static final String TAG = MicrosoftAccount.class.getSimpleName();
    private String mDisplayableId;
    private String mUserId;
    private String mName;
    private String mUid;
    private String mUtid;
    private IDToken mIDToken;
    private URL mPasswordChangeUrl;
    private Date mPasswordExpiresOn;
    private String mTenantId;
    private String mGivenName;
    private String mFamilyName;
    private String mMiddleName;
    private String mEnvironment;
    private String mRawClientInfo;

    public MicrosoftAccount() {
        Logger.verbose(TAG, "Init: " + TAG);
    }

    public MicrosoftAccount(@NonNull IDToken idToken, @NonNull ClientInfo clientInfo) {
        if (idToken == null) {
            throw new NullPointerException("idToken is marked non-null but is null");
        }
        if (clientInfo == null) {
            throw new NullPointerException("clientInfo is marked non-null but is null");
        }
        Logger.verbose(TAG, "Init: " + TAG);
        this.mIDToken = idToken;
        this.mRawClientInfo = clientInfo.getRawClientInfo();
        Map<String, ?> claims = idToken.getTokenClaims();
        this.mUserId = this.getUserId(claims);
        this.mDisplayableId = this.getDisplayableIdFromClaims(claims);
        this.mName = (String)claims.get("name");
        this.mGivenName = (String)claims.get("given_name");
        this.mFamilyName = (String)claims.get("family_name");
        this.mMiddleName = (String)claims.get("middle_name");
        if (!StringUtil.isNullOrEmpty((String)claims.get("tid"))) {
            this.mTenantId = (String)claims.get("tid");
        } else if (!StringUtil.isNullOrEmpty(clientInfo.getUtid())) {
            Logger.warnPII(TAG, "realm is not returned from server. Use utid as realm.");
            this.mTenantId = clientInfo.getUtid();
        } else {
            Logger.warnPII(TAG, "realm and utid is not returned from server. Use empty string as default tid.");
            this.mTenantId = "";
        }
        this.mUid = clientInfo.getUid();
        this.mUtid = clientInfo.getUtid();
        long mPasswordExpiration = 0L;
        Object expiry = claims.get("pwd_exp");
        if (null != expiry) {
            mPasswordExpiration = Long.parseLong(expiry.toString());
        }
        if (mPasswordExpiration > 0L) {
            GregorianCalendar expires = new GregorianCalendar();
            ((Calendar)expires).add(13, (int)mPasswordExpiration);
            this.mPasswordExpiresOn = expires.getTime();
        }
        this.mPasswordChangeUrl = null;
        String passwordChangeUrl = (String)claims.get("pwd_url");
        if (!StringUtil.isNullOrEmpty(passwordChangeUrl)) {
            try {
                this.mPasswordChangeUrl = new URL(passwordChangeUrl);
            }
            catch (MalformedURLException e) {
                Logger.error(TAG, "Failed to parse passwordChangeUrl.", e);
            }
        }
    }

    protected abstract String getDisplayableIdFromClaims(Map<String, ?> var1);

    private String getUserId(Map<String, ?> claims) {
        String methodName = "getUniqueId";
        String uniqueId = null;
        if (!StringUtil.isNullOrEmpty((String)claims.get("oid"))) {
            Logger.info(TAG + ":" + "getUniqueId", "Using ObjectId as uniqueId");
            uniqueId = (String)claims.get("oid");
        } else if (!StringUtil.isNullOrEmpty((String)claims.get("sub"))) {
            Logger.info(TAG + ":" + "getUniqueId", "Using Subject as uniqueId");
            uniqueId = (String)claims.get("sub");
        }
        return uniqueId;
    }

    public synchronized void setFirstName(String givenName) {
        this.mGivenName = givenName;
    }

    public synchronized void setFamilyName(String familyName) {
        this.mFamilyName = familyName;
    }

    public synchronized String getDisplayableId() {
        return this.mDisplayableId;
    }

    public synchronized void setDisplayableId(String displayableId) {
        this.mDisplayableId = displayableId;
    }

    public synchronized String getUserId() {
        return this.mUserId;
    }

    public synchronized String getUid() {
        return this.mUid;
    }

    public synchronized void setUid(String uid) {
        this.mUid = uid;
    }

    public synchronized void setUtid(String uTid) {
        this.mUtid = uTid;
    }

    public synchronized void setName(String name) {
        this.mName = name;
    }

    public synchronized String getUtid() {
        return this.mUtid;
    }

    synchronized void setUserId(String userid) {
        this.mUserId = userid;
    }

    @Override
    public synchronized String getUniqueIdentifier() {
        return Base64.encodeToString((byte[])StringUtil.toByteArray(this.mUid), (int)10) + "." + Base64.encodeToString((byte[])StringUtil.toByteArray(this.mUtid), (int)10);
    }

    @Override
    public synchronized List<String> getCacheIdentifiers() {
        ArrayList<String> cacheIdentifiers = new ArrayList<String>();
        if (this.mDisplayableId != null) {
            cacheIdentifiers.add(this.mDisplayableId);
        }
        if (this.mUserId != null) {
            cacheIdentifiers.add(this.mUserId);
        }
        if (this.getUniqueIdentifier() != null) {
            cacheIdentifiers.add(this.getUniqueIdentifier());
        }
        return cacheIdentifiers;
    }

    public synchronized URL getPasswordChangeUrl() {
        return this.mPasswordChangeUrl;
    }

    @Nullable
    public synchronized Date getPasswordExpiresOn() {
        return CopyUtil.copyIfNotNull(this.mPasswordExpiresOn);
    }

    public synchronized IDToken getIDToken() {
        return this.mIDToken;
    }

    @Override
    public synchronized String getHomeAccountId() {
        return this.getUid() + "." + this.getUtid();
    }

    public synchronized void setEnvironment(String environment) {
        this.mEnvironment = environment;
    }

    @Override
    public synchronized String getEnvironment() {
        return this.mEnvironment;
    }

    @Override
    public synchronized String getRealm() {
        return this.mTenantId;
    }

    @Override
    public synchronized String getLocalAccountId() {
        return this.getUserId();
    }

    @Override
    public synchronized String getUsername() {
        return this.getDisplayableId();
    }

    @Override
    public synchronized String getAlternativeAccountId() {
        return SchemaUtil.getAlternativeAccountId(this.mIDToken);
    }

    @Override
    public synchronized String getFirstName() {
        return this.mGivenName;
    }

    @Override
    public synchronized String getFamilyName() {
        return this.mFamilyName;
    }

    @Override
    public synchronized String getName() {
        return this.mName;
    }

    @Override
    public synchronized String getMiddleName() {
        return this.mMiddleName;
    }

    @Override
    public synchronized String getAvatarUrl() {
        return SchemaUtil.getAvatarUrl(this.mIDToken);
    }

    @Override
    public synchronized String getClientInfo() {
        return this.mRawClientInfo;
    }

    public synchronized String toString() {
        return "MicrosoftAccount{mDisplayableId='" + this.mDisplayableId + '\'' + ", mUserId='" + this.mUserId + '\'' + ", mName='" + this.mName + '\'' + ", mUid='" + this.mUid + '\'' + ", mUtid='" + this.mUtid + '\'' + ", mIDToken=" + this.mIDToken + ", mPasswordChangeUrl=" + this.mPasswordChangeUrl + ", mPasswordExpiresOn=" + this.mPasswordExpiresOn + ", mTenantId='" + this.mTenantId + '\'' + ", mGivenName='" + this.mGivenName + '\'' + ", mFamilyName='" + this.mFamilyName + '\'' + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicrosoftAccount)) {
            return false;
        }
        MicrosoftAccount other = (MicrosoftAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mDisplayableId = this.getDisplayableId();
        String other$mDisplayableId = other.getDisplayableId();
        if (this$mDisplayableId == null ? other$mDisplayableId != null : !this$mDisplayableId.equals(other$mDisplayableId)) {
            return false;
        }
        String this$mUserId = this.getUserId();
        String other$mUserId = other.getUserId();
        if (this$mUserId == null ? other$mUserId != null : !this$mUserId.equals(other$mUserId)) {
            return false;
        }
        String this$mName = this.getName();
        String other$mName = other.getName();
        if (this$mName == null ? other$mName != null : !this$mName.equals(other$mName)) {
            return false;
        }
        String this$mUid = this.getUid();
        String other$mUid = other.getUid();
        if (this$mUid == null ? other$mUid != null : !this$mUid.equals(other$mUid)) {
            return false;
        }
        String this$mUtid = this.getUtid();
        String other$mUtid = other.getUtid();
        if (this$mUtid == null ? other$mUtid != null : !this$mUtid.equals(other$mUtid)) {
            return false;
        }
        IDToken this$mIDToken = this.getIDToken();
        IDToken other$mIDToken = other.getIDToken();
        if (this$mIDToken == null ? other$mIDToken != null : !((Object)this$mIDToken).equals(other$mIDToken)) {
            return false;
        }
        URL this$mPasswordChangeUrl = this.getPasswordChangeUrl();
        URL other$mPasswordChangeUrl = other.getPasswordChangeUrl();
        if (this$mPasswordChangeUrl == null ? other$mPasswordChangeUrl != null : !((Object)this$mPasswordChangeUrl).equals(other$mPasswordChangeUrl)) {
            return false;
        }
        Date this$mPasswordExpiresOn = this.getPasswordExpiresOn();
        Date other$mPasswordExpiresOn = other.getPasswordExpiresOn();
        if (this$mPasswordExpiresOn == null ? other$mPasswordExpiresOn != null : !((Object)this$mPasswordExpiresOn).equals(other$mPasswordExpiresOn)) {
            return false;
        }
        String this$mTenantId = this.mTenantId;
        String other$mTenantId = other.mTenantId;
        if (this$mTenantId == null ? other$mTenantId != null : !this$mTenantId.equals(other$mTenantId)) {
            return false;
        }
        String this$mGivenName = this.mGivenName;
        String other$mGivenName = other.mGivenName;
        if (this$mGivenName == null ? other$mGivenName != null : !this$mGivenName.equals(other$mGivenName)) {
            return false;
        }
        String this$mFamilyName = this.getFamilyName();
        String other$mFamilyName = other.getFamilyName();
        if (this$mFamilyName == null ? other$mFamilyName != null : !this$mFamilyName.equals(other$mFamilyName)) {
            return false;
        }
        String this$mMiddleName = this.getMiddleName();
        String other$mMiddleName = other.getMiddleName();
        if (this$mMiddleName == null ? other$mMiddleName != null : !this$mMiddleName.equals(other$mMiddleName)) {
            return false;
        }
        String this$mEnvironment = this.getEnvironment();
        String other$mEnvironment = other.getEnvironment();
        if (this$mEnvironment == null ? other$mEnvironment != null : !this$mEnvironment.equals(other$mEnvironment)) {
            return false;
        }
        String this$mRawClientInfo = this.mRawClientInfo;
        String other$mRawClientInfo = other.mRawClientInfo;
        return !(this$mRawClientInfo == null ? other$mRawClientInfo != null : !this$mRawClientInfo.equals(other$mRawClientInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MicrosoftAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mDisplayableId = this.getDisplayableId();
        result = result * 59 + ($mDisplayableId == null ? 43 : $mDisplayableId.hashCode());
        String $mUserId = this.getUserId();
        result = result * 59 + ($mUserId == null ? 43 : $mUserId.hashCode());
        String $mName = this.getName();
        result = result * 59 + ($mName == null ? 43 : $mName.hashCode());
        String $mUid = this.getUid();
        result = result * 59 + ($mUid == null ? 43 : $mUid.hashCode());
        String $mUtid = this.getUtid();
        result = result * 59 + ($mUtid == null ? 43 : $mUtid.hashCode());
        IDToken $mIDToken = this.getIDToken();
        result = result * 59 + ($mIDToken == null ? 43 : ((Object)$mIDToken).hashCode());
        URL $mPasswordChangeUrl = this.getPasswordChangeUrl();
        result = result * 59 + ($mPasswordChangeUrl == null ? 43 : ((Object)$mPasswordChangeUrl).hashCode());
        Date $mPasswordExpiresOn = this.getPasswordExpiresOn();
        result = result * 59 + ($mPasswordExpiresOn == null ? 43 : ((Object)$mPasswordExpiresOn).hashCode());
        String $mTenantId = this.mTenantId;
        result = result * 59 + ($mTenantId == null ? 43 : $mTenantId.hashCode());
        String $mGivenName = this.mGivenName;
        result = result * 59 + ($mGivenName == null ? 43 : $mGivenName.hashCode());
        String $mFamilyName = this.getFamilyName();
        result = result * 59 + ($mFamilyName == null ? 43 : $mFamilyName.hashCode());
        String $mMiddleName = this.getMiddleName();
        result = result * 59 + ($mMiddleName == null ? 43 : $mMiddleName.hashCode());
        String $mEnvironment = this.getEnvironment();
        result = result * 59 + ($mEnvironment == null ? 43 : $mEnvironment.hashCode());
        String $mRawClientInfo = this.mRawClientInfo;
        result = result * 59 + ($mRawClientInfo == null ? 43 : $mRawClientInfo.hashCode());
        return result;
    }
}

