/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers;

import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.UrlUtil;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import lombok.NonNull;

public class RawAuthorizationResult {
    private static final String TAG = RawAuthorizationResult.class.getSimpleName();
    private final ResultCode mResultCode;
    @Nullable
    private final URI mAuthorizationFinalUri;
    @Nullable
    private final BaseException mException;

    @NonNull
    public static RawAuthorizationResult fromResultCode(ResultCode resultCode) {
        if (resultCode == ResultCode.NON_OAUTH_ERROR || resultCode == ResultCode.COMPLETED || resultCode == ResultCode.DEVICE_REGISTRATION_REQUIRED || resultCode == ResultCode.BROKER_INSTALLATION_TRIGGERED) {
            throw new IllegalArgumentException("Result code " + (Object)((Object)resultCode) + " should be set via other factory methods");
        }
        return RawAuthorizationResult.builder().resultCode(resultCode).build();
    }

    @NonNull
    public static RawAuthorizationResult fromThrowable(@NonNull Throwable e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        if (e instanceof BaseException) {
            return RawAuthorizationResult.fromException((BaseException)e);
        }
        return RawAuthorizationResult.builder().resultCode(ResultCode.NON_OAUTH_ERROR).exception(new BaseException("unknown_error", "Unknown error with class: " + e.getClass().getSimpleName(), e)).build();
    }

    @NonNull
    public static RawAuthorizationResult fromException(@NonNull BaseException e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        return RawAuthorizationResult.builder().resultCode(ResultCode.NON_OAUTH_ERROR).exception(e).build();
    }

    @NonNull
    public static RawAuthorizationResult fromRedirectUri(@NonNull String redirectUri) {
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        try {
            URI uri = new URI(redirectUri);
            return RawAuthorizationResult.builder().resultCode(RawAuthorizationResult.getResultCodeFromFinalRedirectUri(uri)).authorizationFinalUri(uri).build();
        }
        catch (URISyntaxException e) {
            return RawAuthorizationResult.fromException(new ClientException("malformed_url", "Failed to parse redirect URL", e));
        }
    }

    @NonNull
    public static PropertyBag toPropertyBag(@NonNull RawAuthorizationResult data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.put("com.microsoft.identity.client.result.code", data.mResultCode.mCode);
        propertyBag.put("com.microsoft.aad.adal:BrowserFinalUrl", data.mAuthorizationFinalUri);
        propertyBag.put("com.microsoft.aad.adal:AuthenticationException", data.mException);
        return propertyBag;
    }

    @NonNull
    public static RawAuthorizationResult fromPropertyBag(@NonNull PropertyBag propertyBag) {
        if (propertyBag == null) {
            throw new NullPointerException("propertyBag is marked non-null but is null");
        }
        return RawAuthorizationResult.builder().resultCode(ResultCode.fromInteger((Integer)propertyBag.get("com.microsoft.identity.client.result.code"))).authorizationFinalUri((URI)propertyBag.get("com.microsoft.aad.adal:BrowserFinalUrl")).exception((BaseException)propertyBag.get("com.microsoft.aad.adal:AuthenticationException")).build();
    }

    private static ResultCode getResultCodeFromFinalRedirectUri(@NonNull URI uri) throws URISyntaxException {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        String methodTag = TAG + "getResultCodeFromFinalRedirectUri";
        Map<String, String> parameters = UrlUtil.getParameters(uri);
        if ("msauth".equalsIgnoreCase(uri.getScheme())) {
            if (parameters.containsKey("app_link")) {
                Logger.info(methodTag, "Return to caller with BROWSER_CODE_WAIT_FOR_BROKER_INSTALL, and waiting for result.");
                return ResultCode.BROKER_INSTALLATION_TRIGGERED;
            }
            if ("wpj".equalsIgnoreCase(uri.getHost())) {
                Logger.info(methodTag, " Device needs to be registered, sending BROWSER_CODE_DEVICE_REGISTER");
                return ResultCode.DEVICE_REGISTRATION_REQUIRED;
            }
        }
        if (StringUtil.equalsIgnoreCase(parameters.get("error_subcode"), "cancel")) {
            Logger.info(methodTag, "User cancelled the session");
            return ResultCode.CANCELLED;
        }
        return ResultCode.COMPLETED;
    }

    RawAuthorizationResult(ResultCode resultCode, @Nullable URI authorizationFinalUri, @Nullable BaseException exception) {
        this.mResultCode = resultCode;
        this.mAuthorizationFinalUri = authorizationFinalUri;
        this.mException = exception;
    }

    private static RawAuthorizationResultBuilder builder() {
        return new RawAuthorizationResultBuilder();
    }

    public ResultCode getResultCode() {
        return this.mResultCode;
    }

    @Nullable
    public URI getAuthorizationFinalUri() {
        return this.mAuthorizationFinalUri;
    }

    @Nullable
    public BaseException getException() {
        return this.mException;
    }

    private static class RawAuthorizationResultBuilder {
        private ResultCode resultCode;
        private URI authorizationFinalUri;
        private BaseException exception;

        RawAuthorizationResultBuilder() {
        }

        private RawAuthorizationResultBuilder resultCode(ResultCode resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        private RawAuthorizationResultBuilder authorizationFinalUri(@Nullable URI authorizationFinalUri) {
            this.authorizationFinalUri = authorizationFinalUri;
            return this;
        }

        private RawAuthorizationResultBuilder exception(@Nullable BaseException exception) {
            this.exception = exception;
            return this;
        }

        private RawAuthorizationResult build() {
            return new RawAuthorizationResult(this.resultCode, this.authorizationFinalUri, this.exception);
        }

        public String toString() {
            return "RawAuthorizationResult.RawAuthorizationResultBuilder(resultCode=" + (Object)((Object)this.resultCode) + ", authorizationFinalUri=" + this.authorizationFinalUri + ", exception=" + this.exception + ")";
        }
    }

    public static enum ResultCode {
        UNKNOWN(-1),
        CANCELLED(2001),
        NON_OAUTH_ERROR(2002),
        COMPLETED(2003),
        BROKER_INSTALLATION_TRIGGERED(2006),
        DEVICE_REGISTRATION_REQUIRED(2007),
        SDK_CANCELLED(2008),
        MDM_FLOW(2009);

        private final int mCode;

        private ResultCode(int code) {
            this.mCode = code;
        }

        static ResultCode fromInteger(@Nullable Integer value) {
            if (value == null) {
                return UNKNOWN;
            }
            for (ResultCode resultCode : ResultCode.values()) {
                if (resultCode.mCode != value) continue;
                return resultCode;
            }
            return null;
        }
    }
}

