/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.net;

import com.microsoft.identity.common.java.net.HttpResponse;
import com.microsoft.identity.common.java.net.IRetryPolicy;
import com.microsoft.identity.common.java.net.RetryFailedException;
import com.microsoft.identity.common.java.util.ported.Function;
import java.io.IOException;
import java.util.concurrent.Callable;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@Immutable
public class StatusCodeAndExceptionRetry
implements IRetryPolicy<HttpResponse> {
    private final Function<Exception, Boolean> isRetryableException;
    private final Function<HttpResponse, Boolean> isRetryable;
    private final Function<HttpResponse, Boolean> isAcceptable;
    private final int number;
    private final int initialDelay;
    private final int extensionFactor;

    @Override
    public HttpResponse attempt(Callable<HttpResponse> supplier) throws IOException {
        int attemptNumber = this.number;
        int cumulativeDelay = this.initialDelay;
        do {
            try {
                HttpResponse response = supplier.call();
                if (attemptNumber <= 0 || this.isAcceptable.apply(response).booleanValue() || !this.isRetryable.apply(response).booleanValue()) {
                    return response;
                }
            }
            catch (Exception e) {
                if (attemptNumber > 0 && this.isRetryableException.apply(e).booleanValue()) continue;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RetryFailedException(e);
            }
        } while (attemptNumber-- > 0 && this.waited(cumulativeDelay) && (cumulativeDelay *= this.extensionFactor) > 0);
        throw new IllegalStateException("This code should not be reachable");
    }

    private boolean waited(int cumulativeDelay) {
        try {
            Thread.sleep(cumulativeDelay);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private static Function<Exception, Boolean> $default$isRetryableException() {
        return new Function<Exception, Boolean>(){

            @Override
            public Boolean apply(Exception input) {
                return Boolean.FALSE;
            }
        };
    }

    private static Function<HttpResponse, Boolean> $default$isRetryable() {
        return new Function<HttpResponse, Boolean>(){

            @Override
            public Boolean apply(HttpResponse input) {
                return Boolean.FALSE;
            }
        };
    }

    private static Function<HttpResponse, Boolean> $default$isAcceptable() {
        return new Function<HttpResponse, Boolean>(){

            @Override
            public Boolean apply(HttpResponse input) {
                return Boolean.TRUE;
            }
        };
    }

    private static int $default$number() {
        return 1;
    }

    private static int $default$initialDelay() {
        return 1000;
    }

    private static int $default$extensionFactor() {
        return 2;
    }

    public static StatusCodeAndExceptionRetryBuilder builder() {
        return new StatusCodeAndExceptionRetryBuilder();
    }

    public StatusCodeAndExceptionRetry(Function<Exception, Boolean> isRetryableException, Function<HttpResponse, Boolean> isRetryable, Function<HttpResponse, Boolean> isAcceptable, int number, int initialDelay, int extensionFactor) {
        this.isRetryableException = isRetryableException;
        this.isRetryable = isRetryable;
        this.isAcceptable = isAcceptable;
        this.number = number;
        this.initialDelay = initialDelay;
        this.extensionFactor = extensionFactor;
    }

    public static class StatusCodeAndExceptionRetryBuilder {
        private boolean isRetryableException$set;
        private Function<Exception, Boolean> isRetryableException$value;
        private boolean isRetryable$set;
        private Function<HttpResponse, Boolean> isRetryable$value;
        private boolean isAcceptable$set;
        private Function<HttpResponse, Boolean> isAcceptable$value;
        private boolean number$set;
        private int number$value;
        private boolean initialDelay$set;
        private int initialDelay$value;
        private boolean extensionFactor$set;
        private int extensionFactor$value;

        StatusCodeAndExceptionRetryBuilder() {
        }

        public StatusCodeAndExceptionRetryBuilder isRetryableException(Function<Exception, Boolean> isRetryableException) {
            this.isRetryableException$value = isRetryableException;
            this.isRetryableException$set = true;
            return this;
        }

        public StatusCodeAndExceptionRetryBuilder isRetryable(Function<HttpResponse, Boolean> isRetryable) {
            this.isRetryable$value = isRetryable;
            this.isRetryable$set = true;
            return this;
        }

        public StatusCodeAndExceptionRetryBuilder isAcceptable(Function<HttpResponse, Boolean> isAcceptable) {
            this.isAcceptable$value = isAcceptable;
            this.isAcceptable$set = true;
            return this;
        }

        public StatusCodeAndExceptionRetryBuilder number(int number) {
            this.number$value = number;
            this.number$set = true;
            return this;
        }

        public StatusCodeAndExceptionRetryBuilder initialDelay(int initialDelay) {
            this.initialDelay$value = initialDelay;
            this.initialDelay$set = true;
            return this;
        }

        public StatusCodeAndExceptionRetryBuilder extensionFactor(int extensionFactor) {
            this.extensionFactor$value = extensionFactor;
            this.extensionFactor$set = true;
            return this;
        }

        public StatusCodeAndExceptionRetry build() {
            Function isRetryableException$value = this.isRetryableException$value;
            if (!this.isRetryableException$set) {
                isRetryableException$value = StatusCodeAndExceptionRetry.$default$isRetryableException();
            }
            Function isRetryable$value = this.isRetryable$value;
            if (!this.isRetryable$set) {
                isRetryable$value = StatusCodeAndExceptionRetry.$default$isRetryable();
            }
            Function isAcceptable$value = this.isAcceptable$value;
            if (!this.isAcceptable$set) {
                isAcceptable$value = StatusCodeAndExceptionRetry.$default$isAcceptable();
            }
            int number$value = this.number$value;
            if (!this.number$set) {
                number$value = StatusCodeAndExceptionRetry.$default$number();
            }
            int initialDelay$value = this.initialDelay$value;
            if (!this.initialDelay$set) {
                initialDelay$value = StatusCodeAndExceptionRetry.$default$initialDelay();
            }
            int extensionFactor$value = this.extensionFactor$value;
            if (!this.extensionFactor$set) {
                extensionFactor$value = StatusCodeAndExceptionRetry.$default$extensionFactor();
            }
            return new StatusCodeAndExceptionRetry(isRetryableException$value, isRetryable$value, isAcceptable$value, number$value, initialDelay$value, extensionFactor$value);
        }

        public String toString() {
            return "StatusCodeAndExceptionRetry.StatusCodeAndExceptionRetryBuilder(isRetryableException$value=" + this.isRetryableException$value + ", isRetryable$value=" + this.isRetryable$value + ", isAcceptable$value=" + this.isAcceptable$value + ", number$value=" + this.number$value + ", initialDelay$value=" + this.initialDelay$value + ", extensionFactor$value=" + this.extensionFactor$value + ")";
        }
    }
}

