/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.net;

import com.microsoft.identity.common.java.util.StringUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.jcip.annotations.Immutable;

@Immutable
public class HttpResponse {
    private final int mStatusCode;
    private final String mResponseBody;
    private final Map<String, List<String>> mResponseHeaders;
    private final Date mDate;

    public HttpResponse(int statusCode, String responseBody, Map<String, List<String>> responseHeaders) {
        this(new Date(), statusCode, responseBody, responseHeaders);
    }

    public HttpResponse(@NonNull Date date, int statusCode, String responseBody, Map<String, List<String>> headerFields) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        this.mDate = new Date(date.getTime());
        this.mStatusCode = statusCode;
        this.mResponseBody = responseBody;
        this.mResponseHeaders = headerFields;
    }

    public Date getDate() {
        return new Date(this.mDate.getTime());
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getBody() {
        return this.mResponseBody;
    }

    public Map<String, List<String>> getHeaders() {
        return this.mResponseHeaders;
    }

    @Nullable
    public String getHeaderValue(@NonNull String key, int index) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (this.mResponseHeaders == null || index < 0 || StringUtil.isNullOrEmpty(key)) {
            return null;
        }
        List<String> list = this.mResponseHeaders.get(key);
        if (list == null || list.size() <= index) {
            return null;
        }
        return list.get(index);
    }

    public String toString() {
        return "HttpResponse{mStatusCode=" + this.mStatusCode + ", mResponseBody='" + this.mResponseBody + '\'' + ", mResponseHeaders=" + this.mResponseHeaders + '}';
    }
}

