/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.signup;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.UserAttributeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpContinueApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u009f\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u001a\u0010\b\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n\u0018\u00010\t\u0012\u001a\u0010\u000b\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n\u0018\u00010\t\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\t\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u0005H\u0016J\b\u0010'\u001a\u00020\u0005H\u0016R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u001e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR*\u0010\u000b\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u001e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0014R*\u0010\b\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017\u00a8\u0006)"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpContinueApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "correlationId", "", "continuationToken", "expiresIn", "unverifiedAttributes", "", "", "invalidAttributes", "requiredAttributes", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/UserAttributeApiResult;", "error", "errorCodes", "errorDescription", "subError", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getContinuationToken", "()Ljava/lang/String;", "getError", "getErrorCodes", "()Ljava/util/List;", "getErrorDescription", "getExpiresIn", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getInvalidAttributes", "getRequiredAttributes", "getStatusCode", "()I", "setStatusCode", "(I)V", "getSubError", "getUnverifiedAttributes", "toResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpContinueApiResult;", "toString", "toUnsanitizedString", "Companion", "common4j"})
public final class SignUpContinueApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @SerializedName(value="continuation_token")
    @Nullable
    private final String continuationToken;
    @Expose
    @SerializedName(value="expires_in")
    @Nullable
    private final Integer expiresIn;
    @Expose
    @SerializedName(value="unverified_attributes")
    @Nullable
    private final List<Map<String, String>> unverifiedAttributes;
    @Expose
    @SerializedName(value="invalid_attributes")
    @Nullable
    private final List<Map<String, String>> invalidAttributes;
    @Expose
    @SerializedName(value="required_attributes")
    @Nullable
    private final List<UserAttributeApiResult> requiredAttributes;
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @SerializedName(value="error_codes")
    @Nullable
    private final List<Integer> errorCodes;
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    @SerializedName(value="suberror")
    @Nullable
    private final String subError;
    private static final String TAG = SignUpContinueApiResponse.class.getSimpleName();

    public SignUpContinueApiResponse(int statusCode, @NotNull String correlationId, @Nullable String continuationToken, @Nullable Integer expiresIn, @Nullable List<? extends Map<String, String>> unverifiedAttributes, @Nullable List<? extends Map<String, String>> invalidAttributes, @Nullable List<UserAttributeApiResult> requiredAttributes, @Nullable String error, @Nullable List<Integer> errorCodes, @Nullable String errorDescription, @Nullable String subError) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        super(statusCode, correlationId);
        this.statusCode = statusCode;
        this.continuationToken = continuationToken;
        this.expiresIn = expiresIn;
        this.unverifiedAttributes = unverifiedAttributes;
        this.invalidAttributes = invalidAttributes;
        this.requiredAttributes = requiredAttributes;
        this.error = error;
        this.errorCodes = errorCodes;
        this.errorDescription = errorDescription;
        this.subError = subError;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getContinuationToken() {
        return this.continuationToken;
    }

    @Nullable
    public final Integer getExpiresIn() {
        return this.expiresIn;
    }

    @Nullable
    public final List<Map<String, String>> getUnverifiedAttributes() {
        return this.unverifiedAttributes;
    }

    @Nullable
    public final List<Map<String, String>> getInvalidAttributes() {
        return this.invalidAttributes;
    }

    @Nullable
    public final List<UserAttributeApiResult> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final List<Integer> getErrorCodes() {
        return this.errorCodes;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public final String getSubError() {
        return this.subError;
    }

    @Override
    @NotNull
    public String toUnsanitizedString() {
        return "SignUpContinueApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId() + ", expiresIn=" + this.expiresIn + ", requiredAttributes=" + this.requiredAttributes + ", error=" + this.error + ", errorCodes=" + this.errorCodes + ", errorDescription=" + this.errorDescription + ", subError=" + this.subError + ')';
    }

    @Override
    @NotNull
    public String toString() {
        return "SignUpContinueApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId();
    }

    @NotNull
    public final SignUpContinueApiResult toResult() {
        SignUpContinueApiResult signUpContinueApiResult;
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".toResult");
        switch (this.getStatusCode()) {
            case 400: {
                SignUpContinueApiResult signUpContinueApiResult2;
                if (ApiErrorResponseUtilKt.isInvalidGrant(this.error)) {
                    SignUpContinueApiResult signUpContinueApiResult3;
                    if (ApiErrorResponseUtilKt.isPasswordTooWeak(this.subError) || ApiErrorResponseUtilKt.isPasswordTooLong(this.subError) || ApiErrorResponseUtilKt.isPasswordTooShort(this.subError) || ApiErrorResponseUtilKt.isPasswordBanned(this.subError) || ApiErrorResponseUtilKt.isPasswordRecentlyUsed(this.subError) || ApiErrorResponseUtilKt.isPasswordInvalid(this.subError)) {
                        String string2;
                        String string3;
                        String string4;
                        String string5;
                        String string6 = this.error;
                        if (string6 == null) {
                            string6 = string5 = "";
                        }
                        if ((string4 = this.errorDescription) == null) {
                            string4 = string3 = "";
                        }
                        if ((string2 = this.subError) == null) {
                            string2 = "";
                        }
                        String string7 = string2;
                        String string8 = this.getCorrelationId();
                        signUpContinueApiResult3 = new SignUpContinueApiResult.InvalidPassword(string8, string5, string3, string7);
                    } else if (ApiErrorResponseUtilKt.isAttributeValidationFailed(this.subError)) {
                        List<Object> list;
                        String string9;
                        String string10;
                        String string11;
                        String string12 = this.error;
                        if (string12 == null) {
                            string12 = string11 = "";
                        }
                        if ((string10 = this.errorDescription) == null) {
                            string10 = string9 = "";
                        }
                        if ((list = this.invalidAttributes) == null || (list = ApiErrorResponseUtilKt.toAttributeList(list)) == null) {
                            String string13 = this.getCorrelationId();
                            return new SignUpContinueApiResult.UnknownError(string13, "invalid_state", "SignUp /continue did not return a invalid_attributes with validation_failed error");
                        }
                        List<Object> list2 = list;
                        String string14 = this.subError;
                        if (string14 == null) {
                            string14 = "";
                        }
                        String string15 = string14;
                        String string16 = this.getCorrelationId();
                        signUpContinueApiResult3 = new SignUpContinueApiResult.InvalidAttributes(string16, list2, string11, string9, string15);
                    } else if (ApiErrorResponseUtilKt.isInvalidOOBValue(this.subError)) {
                        String string17;
                        String string18;
                        String string19;
                        String string20;
                        String string21 = this.error;
                        if (string21 == null) {
                            string21 = string20 = "";
                        }
                        if ((string19 = this.errorDescription) == null) {
                            string19 = string18 = "";
                        }
                        if ((string17 = this.subError) == null) {
                            string17 = "";
                        }
                        String string22 = string17;
                        String string23 = this.getCorrelationId();
                        signUpContinueApiResult3 = new SignUpContinueApiResult.InvalidOOBValue(string23, string20, string18, string22);
                    } else {
                        String string24;
                        String string25;
                        String string26 = this.error;
                        if (string26 == null) {
                            string26 = string25 = "";
                        }
                        if ((string24 = this.errorDescription) == null) {
                            string24 = "";
                        }
                        String string27 = string24;
                        String string28 = this.getCorrelationId();
                        signUpContinueApiResult3 = new SignUpContinueApiResult.UnknownError(string28, string25, string27);
                    }
                    return signUpContinueApiResult3;
                }
                if (ApiErrorResponseUtilKt.isUserAlreadyExists(this.error)) {
                    String string29;
                    String string30;
                    String string31 = this.error;
                    if (string31 == null) {
                        string31 = string30 = "";
                    }
                    if ((string29 = this.errorDescription) == null) {
                        string29 = "";
                    }
                    String string32 = string29;
                    String string33 = this.getCorrelationId();
                    signUpContinueApiResult2 = new SignUpContinueApiResult.UsernameAlreadyExists(string33, string30, string32);
                } else if (ApiErrorResponseUtilKt.isExpiredToken(this.error)) {
                    String string34;
                    String string35;
                    String string36 = this.error;
                    if (string36 == null) {
                        string36 = string35 = "";
                    }
                    if ((string34 = this.errorDescription) == null) {
                        string34 = "";
                    }
                    String string37 = string34;
                    String string38 = this.getCorrelationId();
                    signUpContinueApiResult2 = new SignUpContinueApiResult.ExpiredToken(string38, string35, string37);
                } else if (ApiErrorResponseUtilKt.isAttributesRequired(this.error)) {
                    String string39;
                    String string40;
                    String string41 = this.continuationToken;
                    if (string41 == null) {
                        String string42 = ApiErrorResult.Companion.getINVALID_STATE();
                        String string43 = this.getCorrelationId();
                        return new SignUpContinueApiResult.UnknownError(string43, string42, "SignUp /continue did not return a continuation token with attributes_required error");
                    }
                    String string44 = string41;
                    String string45 = this.error;
                    if (string45 == null) {
                        string45 = string40 = "";
                    }
                    if ((string39 = this.errorDescription) == null) {
                        string39 = "";
                    }
                    String string46 = string39;
                    List<UserAttributeApiResult> list = this.requiredAttributes;
                    if (list == null) {
                        String string47 = ApiErrorResult.Companion.getINVALID_STATE();
                        String string48 = this.getCorrelationId();
                        return new SignUpContinueApiResult.UnknownError(string48, string47, "SignUp /continue did not return required_attributes with attributes_required error");
                    }
                    List<UserAttributeApiResult> list3 = list;
                    String string49 = this.getCorrelationId();
                    signUpContinueApiResult2 = new SignUpContinueApiResult.AttributesRequired(string49, string44, string40, string46, list3);
                } else if (ApiErrorResponseUtilKt.isCredentialRequired(this.error)) {
                    String string50;
                    String string51;
                    String string52 = this.continuationToken;
                    if (string52 == null) {
                        String string53 = ApiErrorResult.Companion.getINVALID_STATE();
                        String string54 = this.getCorrelationId();
                        return new SignUpContinueApiResult.UnknownError(string54, string53, "SignUp /continue did not return a continuation token with credential_required");
                    }
                    String string55 = string52;
                    String string56 = this.error;
                    if (string56 == null) {
                        string56 = string51 = "";
                    }
                    if ((string50 = this.errorDescription) == null) {
                        string50 = "";
                    }
                    String string57 = string50;
                    String string58 = this.getCorrelationId();
                    signUpContinueApiResult2 = new SignUpContinueApiResult.CredentialRequired(string58, string55, string51, string57);
                } else if (ApiErrorResponseUtilKt.isVerificationRequired(this.error)) {
                    String string59;
                    String string60;
                    String string61 = this.error;
                    if (string61 == null) {
                        string61 = string60 = "";
                    }
                    if ((string59 = this.errorDescription) == null) {
                        string59 = "";
                    }
                    String string62 = string59;
                    String string63 = this.getCorrelationId();
                    signUpContinueApiResult2 = new SignUpContinueApiResult.UnknownError(string63, string60, string62);
                } else {
                    String string64;
                    String string65;
                    String string66 = this.error;
                    if (string66 == null) {
                        string66 = string65 = "";
                    }
                    if ((string64 = this.errorDescription) == null) {
                        string64 = "";
                    }
                    String string67 = string64;
                    String string68 = this.getCorrelationId();
                    signUpContinueApiResult2 = new SignUpContinueApiResult.UnknownError(string68, string65, string67);
                }
                return signUpContinueApiResult2;
            }
            case 200: {
                String string69 = this.continuationToken;
                Integer n = this.expiresIn;
                String string70 = this.getCorrelationId();
                signUpContinueApiResult = new SignUpContinueApiResult.Success(string70, string69, n);
                break;
            }
            default: {
                String string71;
                String string72;
                String string73 = this.error;
                if (string73 == null) {
                    string73 = string72 = "";
                }
                if ((string71 = this.errorDescription) == null) {
                    string71 = "";
                }
                String string74 = string71;
                String string75 = this.getCorrelationId();
                signUpContinueApiResult = new SignUpContinueApiResult.UnknownError(string75, string72, string74);
            }
        }
        return signUpContinueApiResult;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpContinueApiResponse$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

