/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.signup;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0001$Bo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u0005H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016R\u0018\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\f\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0018\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\t\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0018\u0010\r\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u001b\u0010\u0016R\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpChallengeApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "correlationId", "", "continuationToken", "challengeType", "challengeTargetLabel", "codeLength", "bindingMethod", "interval", "challengeChannel", "error", "errorDescription", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBindingMethod", "()Ljava/lang/String;", "getChallengeChannel", "getChallengeTargetLabel", "getChallengeType", "getCodeLength", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getContinuationToken", "getError", "getErrorDescription", "getInterval", "getStatusCode", "()I", "setStatusCode", "(I)V", "toResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpChallengeApiResult;", "toString", "toUnsanitizedString", "Companion", "common4j"})
public final class SignUpChallengeApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @SerializedName(value="continuation_token")
    @Nullable
    private final String continuationToken;
    @Expose
    @SerializedName(value="challenge_type")
    @Nullable
    private final String challengeType;
    @SerializedName(value="challenge_target_label")
    @Nullable
    private final String challengeTargetLabel;
    @Expose
    @SerializedName(value="code_length")
    @Nullable
    private final Integer codeLength;
    @Expose
    @SerializedName(value="binding_method")
    @Nullable
    private final String bindingMethod;
    @Expose
    @SerializedName(value="interval")
    @Nullable
    private final Integer interval;
    @Expose
    @SerializedName(value="challenge_channel")
    @Nullable
    private final String challengeChannel;
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    private static final String TAG = SignUpChallengeApiResponse.class.getSimpleName();

    public SignUpChallengeApiResponse(int statusCode, @NotNull String correlationId, @Nullable String continuationToken, @Nullable String challengeType, @Nullable String challengeTargetLabel, @Nullable Integer codeLength, @Nullable String bindingMethod, @Nullable Integer interval, @Nullable String challengeChannel, @Nullable String error, @Nullable String errorDescription) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        super(statusCode, correlationId);
        this.statusCode = statusCode;
        this.continuationToken = continuationToken;
        this.challengeType = challengeType;
        this.challengeTargetLabel = challengeTargetLabel;
        this.codeLength = codeLength;
        this.bindingMethod = bindingMethod;
        this.interval = interval;
        this.challengeChannel = challengeChannel;
        this.error = error;
        this.errorDescription = errorDescription;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getContinuationToken() {
        return this.continuationToken;
    }

    @Nullable
    public final String getChallengeType() {
        return this.challengeType;
    }

    @Nullable
    public final String getChallengeTargetLabel() {
        return this.challengeTargetLabel;
    }

    @Nullable
    public final Integer getCodeLength() {
        return this.codeLength;
    }

    @Nullable
    public final String getBindingMethod() {
        return this.bindingMethod;
    }

    @Nullable
    public final Integer getInterval() {
        return this.interval;
    }

    @Nullable
    public final String getChallengeChannel() {
        return this.challengeChannel;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Override
    @NotNull
    public String toUnsanitizedString() {
        return "SignInChallengeApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId() + ", challengeType=" + this.challengeType + ", bindingMethod=" + this.bindingMethod + ", challengeTargetLabel=" + this.challengeTargetLabel + ", challengeChannel=" + this.challengeChannel + ", codeLength=" + this.codeLength + ", interval=" + this.interval + ", error=" + this.error + ", errorDescription=" + this.errorDescription + ')';
    }

    @Override
    @NotNull
    public String toString() {
        return "SignInChallengeApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId();
    }

    @NotNull
    public final SignUpChallengeApiResult toResult() {
        String string;
        String string2 = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
        LogSession.Companion.logMethodCall(string2, null, TAG + ".toResult");
        switch (this.getStatusCode()) {
            case 400: {
                SignUpChallengeApiResult signUpChallengeApiResult;
                if (ApiErrorResponseUtilKt.isUnsupportedChallengeType(this.error)) {
                    String string3;
                    String string4;
                    String string5 = this.error;
                    if (string5 == null) {
                        string5 = string4 = "";
                    }
                    if ((string3 = this.errorDescription) == null) {
                        string3 = "";
                    }
                    String string6 = string3;
                    String string7 = this.getCorrelationId();
                    signUpChallengeApiResult = new SignUpChallengeApiResult.UnsupportedChallengeType(string7, string4, string6);
                } else if (ApiErrorResponseUtilKt.isExpiredToken(this.error)) {
                    String string8;
                    String string9;
                    String string10 = this.error;
                    if (string10 == null) {
                        string10 = string9 = "";
                    }
                    if ((string8 = this.errorDescription) == null) {
                        string8 = "";
                    }
                    String string11 = string8;
                    String string12 = this.getCorrelationId();
                    signUpChallengeApiResult = new SignUpChallengeApiResult.ExpiredToken(string12, string9, string11);
                } else {
                    String string13;
                    String string14 = this.error;
                    if (string14 == null) {
                        string14 = "";
                    }
                    if ((string13 = this.errorDescription) == null) {
                        string13 = "";
                    }
                    signUpChallengeApiResult = new SignUpChallengeApiResult.UnknownError(string14, string13, this.getCorrelationId());
                }
                return signUpChallengeApiResult;
            }
            case 200: {
                SignUpChallengeApiResult signUpChallengeApiResult;
                if (ApiErrorResponseUtilKt.isRedirect(this.challengeType)) {
                    signUpChallengeApiResult = new SignUpChallengeApiResult.Redirect(this.getCorrelationId());
                } else {
                    if (ApiErrorResponseUtilKt.isOOB(this.challengeType)) {
                        SignUpChallengeApiResult signUpChallengeApiResult2;
                        CharSequence charSequence = this.challengeTargetLabel;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                            signUpChallengeApiResult2 = new SignUpChallengeApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /challenge did not return a challenge_target_label with oob challenge type", this.getCorrelationId());
                        } else {
                            charSequence = this.challengeChannel;
                            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                                signUpChallengeApiResult2 = new SignUpChallengeApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /challenge did not return a challenge_channel with oob challenge type", this.getCorrelationId());
                            } else if (this.codeLength == null) {
                                signUpChallengeApiResult2 = new SignUpChallengeApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /challenge did not return a code_length with oob challenge type", this.getCorrelationId());
                            } else {
                                String string15 = this.continuationToken;
                                if (string15 == null) {
                                    return new SignUpChallengeApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /challenge did not return a continuation token with oob challenge type", this.getCorrelationId());
                                }
                                charSequence = string15;
                                String string16 = this.challengeTargetLabel;
                                String string17 = this.challengeChannel;
                                Integer n = this.codeLength;
                                String string18 = this.getCorrelationId();
                                signUpChallengeApiResult2 = new SignUpChallengeApiResult.OOBRequired(string18, (String)charSequence, string16, string17, n);
                            }
                        }
                        return signUpChallengeApiResult2;
                    }
                    if (ApiErrorResponseUtilKt.isPassword(this.challengeType)) {
                        String string19 = this.continuationToken;
                        if (string19 == null) {
                            return new SignUpChallengeApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /challenge did not return a continuation token with password challenge type", this.getCorrelationId());
                        }
                        String string20 = string19;
                        String string21 = this.getCorrelationId();
                        signUpChallengeApiResult = new SignUpChallengeApiResult.PasswordRequired(string21, string20);
                    } else {
                        String string22;
                        String string23 = this.error;
                        if (string23 == null) {
                            string23 = "";
                        }
                        if ((string22 = this.errorDescription) == null) {
                            string22 = "";
                        }
                        signUpChallengeApiResult = new SignUpChallengeApiResult.UnknownError(string23, string22, this.getCorrelationId());
                    }
                }
                return signUpChallengeApiResult;
            }
        }
        String string24 = this.error;
        if (string24 == null) {
            string24 = "";
        }
        if ((string = this.errorDescription) == null) {
            string = "";
        }
        return new SignUpChallengeApiResult.UnknownError(string24, string, this.getCorrelationId());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpChallengeApiResponse$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

