/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.signin;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInInitiateApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0018\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0018\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInInitiateApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "correlationId", "", "continuationToken", "challengeType", "error", "errorDescription", "errorUri", "errorCodes", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getChallengeType", "()Ljava/lang/String;", "getContinuationToken", "getError", "getErrorCodes", "()Ljava/util/List;", "getErrorDescription", "getErrorUri", "getStatusCode", "()I", "setStatusCode", "(I)V", "toResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInInitiateApiResult;", "toString", "toUnsanitizedString", "Companion", "common4j"})
public final class SignInInitiateApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @SerializedName(value="continuation_token")
    @Nullable
    private final String continuationToken;
    @Expose
    @SerializedName(value="challenge_type")
    @Nullable
    private final String challengeType;
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    @SerializedName(value="error_uri")
    @Nullable
    private final String errorUri;
    @SerializedName(value="error_codes")
    @Nullable
    private final List<Integer> errorCodes;
    private static final String TAG = SignInInitiateApiResponse.class.getSimpleName();

    public SignInInitiateApiResponse(int statusCode, @NotNull String correlationId, @Nullable String continuationToken, @Nullable String challengeType, @Nullable String error, @Nullable String errorDescription, @Nullable String errorUri, @Nullable List<Integer> errorCodes) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        super(statusCode, correlationId);
        this.statusCode = statusCode;
        this.continuationToken = continuationToken;
        this.challengeType = challengeType;
        this.error = error;
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
        this.errorCodes = errorCodes;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getContinuationToken() {
        return this.continuationToken;
    }

    @Nullable
    public final String getChallengeType() {
        return this.challengeType;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public final String getErrorUri() {
        return this.errorUri;
    }

    @Nullable
    public final List<Integer> getErrorCodes() {
        return this.errorCodes;
    }

    @Override
    @NotNull
    public String toUnsanitizedString() {
        return "SignInInitiateApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId() + ", challengeType=" + this.challengeType + ", error=" + this.error + ", errorDescription=" + this.errorDescription + ", errorCodes=" + this.errorCodes + ", errorUri=" + this.errorUri + ')';
    }

    @Override
    @NotNull
    public String toString() {
        return "SignInInitiateApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId();
    }

    @NotNull
    public final SignInInitiateApiResult toResult() {
        SignInInitiateApiResult signInInitiateApiResult;
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".toResult");
        switch (this.getStatusCode()) {
            case 400: {
                ApiResult apiResult;
                if (ApiErrorResponseUtilKt.isUserNotFound(this.error)) {
                    List list;
                    String string2;
                    String string3;
                    String string4;
                    String string5 = this.error;
                    if (string5 == null) {
                        string5 = string4 = "";
                    }
                    if ((string3 = this.errorDescription) == null) {
                        string3 = string2 = "";
                    }
                    if ((list = this.errorCodes) == null) {
                        list = CollectionsKt.emptyList();
                    }
                    List list2 = list;
                    String string6 = this.getCorrelationId();
                    apiResult = new SignInInitiateApiResult.UserNotFound(string6, string4, string2, list2);
                } else {
                    List list;
                    String string7;
                    String string8;
                    String string9;
                    String string10 = this.error;
                    if (string10 == null) {
                        string10 = string9 = "";
                    }
                    if ((string8 = this.errorDescription) == null) {
                        string8 = string7 = "";
                    }
                    if ((list = this.errorCodes) == null) {
                        list = CollectionsKt.emptyList();
                    }
                    List list3 = list;
                    String string11 = this.getCorrelationId();
                    apiResult = new SignInInitiateApiResult.UnknownError(string11, string9, string7, list3);
                }
                signInInitiateApiResult = (SignInInitiateApiResult)apiResult;
                break;
            }
            case 200: {
                if (ApiErrorResponseUtilKt.isRedirect(this.challengeType)) {
                    signInInitiateApiResult = new SignInInitiateApiResult.Redirect(this.getCorrelationId());
                    break;
                }
                String string12 = this.continuationToken;
                if (string12 == null) {
                    String string13 = ApiErrorResult.Companion.getINVALID_STATE();
                    List list = this.errorCodes;
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    List list4 = list;
                    String string14 = this.getCorrelationId();
                    return new SignInInitiateApiResult.UnknownError(string14, string13, "SignIn /initiate did not return a flow token", list4);
                }
                String string15 = string12;
                String string16 = this.getCorrelationId();
                signInInitiateApiResult = new SignInInitiateApiResult.Success(string16, string15);
                break;
            }
            default: {
                List list;
                String string17;
                String string18;
                String string19;
                String string20 = this.error;
                if (string20 == null) {
                    string20 = string19 = "";
                }
                if ((string18 = this.errorDescription) == null) {
                    string18 = string17 = "";
                }
                if ((list = this.errorCodes) == null) {
                    list = CollectionsKt.emptyList();
                }
                List list5 = list;
                String string21 = this.getCorrelationId();
                signInInitiateApiResult = new SignInInitiateApiResult.UnknownError(string21, string19, string17, list5);
            }
        }
        return signInInitiateApiResult;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInInitiateApiResponse$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

