/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.signin;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\u00020\u0001:\u0001*B\u0089\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\u0005H\u0016J\b\u0010)\u001a\u00020\u0005H\u0016R\u0018\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0018\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0018\u0010\r\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R\u001e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0014R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014R\u001a\u0010\f\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b!\u0010\u0019R\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006+"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInChallengeApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "correlationId", "", "continuationToken", "challengeType", "bindingMethod", "challengeTargetLabel", "challengeChannel", "codeLength", "interval", "error", "errorCodes", "", "errorDescription", "errorUri", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getBindingMethod", "()Ljava/lang/String;", "getChallengeChannel", "getChallengeTargetLabel", "getChallengeType", "getCodeLength", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getContinuationToken", "getError", "getErrorCodes", "()Ljava/util/List;", "getErrorDescription", "getErrorUri", "getInterval", "getStatusCode", "()I", "setStatusCode", "(I)V", "toResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInChallengeApiResult;", "toString", "toUnsanitizedString", "Companion", "common4j"})
public final class SignInChallengeApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @SerializedName(value="continuation_token")
    @Nullable
    private final String continuationToken;
    @Expose
    @SerializedName(value="challenge_type")
    @Nullable
    private final String challengeType;
    @Expose
    @SerializedName(value="binding_method")
    @Nullable
    private final String bindingMethod;
    @SerializedName(value="challenge_target_label")
    @Nullable
    private final String challengeTargetLabel;
    @Expose
    @SerializedName(value="challenge_channel")
    @Nullable
    private final String challengeChannel;
    @Expose
    @SerializedName(value="code_length")
    @Nullable
    private final Integer codeLength;
    @Expose
    @SerializedName(value="interval")
    @Nullable
    private final Integer interval;
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @SerializedName(value="error_codes")
    @Nullable
    private final List<Integer> errorCodes;
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    @SerializedName(value="error_uri")
    @Nullable
    private final String errorUri;
    private static final String TAG = SignInChallengeApiResponse.class.getSimpleName();
    @NotNull
    private static final String INVALID_GRANT = "invalid_grant";

    public SignInChallengeApiResponse(int statusCode, @NotNull String correlationId, @Nullable String continuationToken, @Nullable String challengeType, @Nullable String bindingMethod, @Nullable String challengeTargetLabel, @Nullable String challengeChannel, @Nullable Integer codeLength, @Nullable Integer interval, @Nullable String error, @Nullable List<Integer> errorCodes, @Nullable String errorDescription, @Nullable String errorUri) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        super(statusCode, correlationId);
        this.statusCode = statusCode;
        this.continuationToken = continuationToken;
        this.challengeType = challengeType;
        this.bindingMethod = bindingMethod;
        this.challengeTargetLabel = challengeTargetLabel;
        this.challengeChannel = challengeChannel;
        this.codeLength = codeLength;
        this.interval = interval;
        this.error = error;
        this.errorCodes = errorCodes;
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getContinuationToken() {
        return this.continuationToken;
    }

    @Nullable
    public final String getChallengeType() {
        return this.challengeType;
    }

    @Nullable
    public final String getBindingMethod() {
        return this.bindingMethod;
    }

    @Nullable
    public final String getChallengeTargetLabel() {
        return this.challengeTargetLabel;
    }

    @Nullable
    public final String getChallengeChannel() {
        return this.challengeChannel;
    }

    @Nullable
    public final Integer getCodeLength() {
        return this.codeLength;
    }

    @Nullable
    public final Integer getInterval() {
        return this.interval;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final List<Integer> getErrorCodes() {
        return this.errorCodes;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public final String getErrorUri() {
        return this.errorUri;
    }

    @Override
    @NotNull
    public String toUnsanitizedString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SignInChallengeApiResponse(statusCode=").append(this.getStatusCode()).append(", correlationId=").append(this.getCorrelationId()).append(", challengeType=").append(this.challengeType).append(", bindingMethod=").append(this.bindingMethod).append(", challengeTargetLabel=").append(this.challengeTargetLabel).append(", challengeChannel=").append(this.challengeChannel).append(", codeLength=").append(this.codeLength).append(", interval=").append(this.interval).append(", error=").append(this.error).append(", errorDescription=").append(this.errorDescription).append(", errorCodes=").append(this.errorCodes).append(", errorUri=");
        stringBuilder.append(this.errorUri).append(')');
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String toString() {
        return "SignInChallengeApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId();
    }

    @NotNull
    public final SignInChallengeApiResult toResult() {
        SignInChallengeApiResult signInChallengeApiResult;
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".toResult");
        switch (this.getStatusCode()) {
            case 400: {
                SignInChallengeApiResult.UnknownError unknownError;
                if (Intrinsics.areEqual((Object)this.error, (Object)INVALID_GRANT)) {
                    List list;
                    String string2;
                    String string3 = this.error;
                    String string4 = this.errorDescription;
                    if (string4 == null) {
                        string4 = string2 = "";
                    }
                    if ((list = this.errorCodes) == null) {
                        list = CollectionsKt.emptyList();
                    }
                    List list2 = list;
                    String string5 = this.getCorrelationId();
                    unknownError = new SignInChallengeApiResult.UnknownError(string5, string3, string2, list2);
                } else {
                    List list;
                    String string6;
                    String string7;
                    String string8;
                    String string9 = this.error;
                    if (string9 == null) {
                        string9 = string8 = "";
                    }
                    if ((string7 = this.errorDescription) == null) {
                        string7 = string6 = "";
                    }
                    if ((list = this.errorCodes) == null) {
                        list = CollectionsKt.emptyList();
                    }
                    List list3 = list;
                    String string10 = this.getCorrelationId();
                    unknownError = new SignInChallengeApiResult.UnknownError(string10, string8, string6, list3);
                }
                signInChallengeApiResult = unknownError;
                break;
            }
            case 200: {
                SignInChallengeApiResult signInChallengeApiResult2;
                if (ApiErrorResponseUtilKt.isRedirect(this.challengeType)) {
                    signInChallengeApiResult2 = new SignInChallengeApiResult.Redirect(this.getCorrelationId());
                } else {
                    if (ApiErrorResponseUtilKt.isOOB(this.challengeType)) {
                        SignInChallengeApiResult signInChallengeApiResult3;
                        CharSequence charSequence = this.challengeTargetLabel;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                            charSequence = ApiErrorResult.Companion.getINVALID_STATE();
                            List list = this.errorCodes;
                            if (list == null) {
                                list = CollectionsKt.emptyList();
                            }
                            List list4 = list;
                            String string11 = this.getCorrelationId();
                            signInChallengeApiResult3 = new SignInChallengeApiResult.UnknownError(string11, (String)charSequence, "SignIn /challenge did not return a challenge_target_label with oob challenge type", list4);
                        } else {
                            charSequence = this.challengeChannel;
                            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                                charSequence = ApiErrorResult.Companion.getINVALID_STATE();
                                List list = this.errorCodes;
                                if (list == null) {
                                    list = CollectionsKt.emptyList();
                                }
                                List list5 = list;
                                String string12 = this.getCorrelationId();
                                signInChallengeApiResult3 = new SignInChallengeApiResult.UnknownError(string12, (String)charSequence, "SignIn /challenge did not return a challenge_channel with oob challenge type", list5);
                            } else if (this.codeLength == null) {
                                charSequence = ApiErrorResult.Companion.getINVALID_STATE();
                                List list = this.errorCodes;
                                if (list == null) {
                                    list = CollectionsKt.emptyList();
                                }
                                List list6 = list;
                                String string13 = this.getCorrelationId();
                                signInChallengeApiResult3 = new SignInChallengeApiResult.UnknownError(string13, (String)charSequence, "SignIn /challenge did not return a code_length with oob challenge type", list6);
                            } else {
                                String string14 = this.continuationToken;
                                if (string14 == null) {
                                    String string15 = ApiErrorResult.Companion.getINVALID_STATE();
                                    List list = this.errorCodes;
                                    if (list == null) {
                                        list = CollectionsKt.emptyList();
                                    }
                                    List list7 = list;
                                    String string16 = this.getCorrelationId();
                                    return new SignInChallengeApiResult.UnknownError(string16, string15, "SignIn /challenge did not return a continuation token with oob challenge type", list7);
                                }
                                charSequence = string14;
                                String string17 = this.challengeTargetLabel;
                                Integer n = this.codeLength;
                                String string18 = this.challengeChannel;
                                String string19 = this.getCorrelationId();
                                signInChallengeApiResult3 = new SignInChallengeApiResult.OOBRequired(string19, (String)charSequence, string17, string18, n);
                            }
                        }
                        return signInChallengeApiResult3;
                    }
                    if (ApiErrorResponseUtilKt.isPassword(this.challengeType)) {
                        String string20 = this.continuationToken;
                        if (string20 == null) {
                            String string21 = ApiErrorResult.Companion.getINVALID_STATE();
                            List list = this.errorCodes;
                            if (list == null) {
                                list = CollectionsKt.emptyList();
                            }
                            List list8 = list;
                            String string22 = this.getCorrelationId();
                            return new SignInChallengeApiResult.UnknownError(string22, string21, "SignIn /challenge did not return a continuation token with password challenge type", list8);
                        }
                        String string23 = string20;
                        String string24 = this.getCorrelationId();
                        signInChallengeApiResult2 = new SignInChallengeApiResult.PasswordRequired(string24, string23);
                    } else {
                        List list;
                        String string25;
                        String string26;
                        String string27;
                        String string28 = this.error;
                        if (string28 == null) {
                            string28 = string27 = "";
                        }
                        if ((string26 = this.errorDescription) == null) {
                            string26 = string25 = "";
                        }
                        if ((list = this.errorCodes) == null) {
                            list = CollectionsKt.emptyList();
                        }
                        List list9 = list;
                        String string29 = this.getCorrelationId();
                        signInChallengeApiResult2 = new SignInChallengeApiResult.UnknownError(string29, string27, string25, list9);
                    }
                }
                return signInChallengeApiResult2;
            }
            default: {
                List list;
                String string30;
                String string31;
                String string32;
                String string33 = this.error;
                if (string33 == null) {
                    string33 = string32 = "";
                }
                if ((string31 = this.errorDescription) == null) {
                    string31 = string30 = "";
                }
                if ((list = this.errorCodes) == null) {
                    list = CollectionsKt.emptyList();
                }
                List list10 = list;
                String string34 = this.getCorrelationId();
                signInChallengeApiResult = new SignInChallengeApiResult.UnknownError(string34, string32, string30, list10);
            }
        }
        return signInChallengeApiResult;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInChallengeApiResponse$Companion;", "", "()V", "INVALID_GRANT", "", "TAG", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

