/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordStartApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0018\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0018\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0018\u0010\n\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordStartApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "correlationId", "", "continuationToken", "challengeType", "error", "errorDescription", "errorUri", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getChallengeType", "()Ljava/lang/String;", "getContinuationToken", "getError", "getErrorDescription", "getErrorUri", "getStatusCode", "()I", "setStatusCode", "(I)V", "toResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordStartApiResult;", "toString", "toUnsanitizedString", "Companion", "common4j"})
public final class ResetPasswordStartApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @SerializedName(value="continuation_token")
    @Nullable
    private final String continuationToken;
    @Expose
    @SerializedName(value="challenge_type")
    @Nullable
    private final String challengeType;
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    @SerializedName(value="error_uri")
    @Nullable
    private final String errorUri;
    private static final String TAG = ResetPasswordStartApiResponse.class.getSimpleName();

    public ResetPasswordStartApiResponse(int statusCode, @NotNull String correlationId, @Nullable String continuationToken, @Nullable String challengeType, @Nullable String error, @Nullable String errorDescription, @Nullable String errorUri) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        super(statusCode, correlationId);
        this.statusCode = statusCode;
        this.continuationToken = continuationToken;
        this.challengeType = challengeType;
        this.error = error;
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getContinuationToken() {
        return this.continuationToken;
    }

    @Nullable
    public final String getChallengeType() {
        return this.challengeType;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public final String getErrorUri() {
        return this.errorUri;
    }

    @Override
    @NotNull
    public String toUnsanitizedString() {
        return "ResetPasswordStartApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId() + ", challengeType=" + this.challengeType + ", error=" + this.error + ", errorUri=" + this.errorUri + ", errorDescription=" + this.errorDescription + ')';
    }

    @Override
    @NotNull
    public String toString() {
        return "ResetPasswordStartApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId();
    }

    @NotNull
    public final ResetPasswordStartApiResult toResult() {
        ResetPasswordStartApiResult resetPasswordStartApiResult;
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".toResult");
        switch (this.getStatusCode()) {
            case 400: {
                ResetPasswordStartApiResult resetPasswordStartApiResult2;
                if (ApiErrorResponseUtilKt.isUserNotFound(this.error)) {
                    String string2;
                    String string3;
                    String string4 = this.error;
                    if (string4 == null) {
                        string4 = string3 = "";
                    }
                    if ((string2 = this.errorDescription) == null) {
                        string2 = "";
                    }
                    String string5 = string2;
                    String string6 = this.getCorrelationId();
                    resetPasswordStartApiResult2 = new ResetPasswordStartApiResult.UserNotFound(string6, string3, string5);
                } else if (ApiErrorResponseUtilKt.isUnsupportedChallengeType(this.error)) {
                    String string7;
                    String string8;
                    String string9 = this.error;
                    if (string9 == null) {
                        string9 = string8 = "";
                    }
                    if ((string7 = this.errorDescription) == null) {
                        string7 = "";
                    }
                    String string10 = string7;
                    String string11 = this.getCorrelationId();
                    resetPasswordStartApiResult2 = new ResetPasswordStartApiResult.UnsupportedChallengeType(string11, string8, string10);
                } else {
                    String string12;
                    String string13;
                    String string14 = this.error;
                    if (string14 == null) {
                        string14 = string13 = "";
                    }
                    if ((string12 = this.errorDescription) == null) {
                        string12 = "";
                    }
                    String string15 = string12;
                    String string16 = this.getCorrelationId();
                    resetPasswordStartApiResult2 = new ResetPasswordStartApiResult.UnknownError(string16, string13, string15);
                }
                return resetPasswordStartApiResult2;
            }
            case 200: {
                if (ApiErrorResponseUtilKt.isRedirect(this.challengeType)) {
                    resetPasswordStartApiResult = new ResetPasswordStartApiResult.Redirect(this.getCorrelationId());
                    break;
                }
                String string17 = this.continuationToken;
                if (string17 == null) {
                    String string18 = this.getCorrelationId();
                    return new ResetPasswordStartApiResult.UnknownError(string18, "invalid_state", "ResetPassword /start returned redirect challenge, but did not return a flow token");
                }
                resetPasswordStartApiResult = new ResetPasswordStartApiResult.Success(string17, this.getCorrelationId());
                break;
            }
            default: {
                String string19;
                String string20;
                String string21 = this.error;
                if (string21 == null) {
                    string21 = string20 = "";
                }
                if ((string19 = this.errorDescription) == null) {
                    string19 = "";
                }
                String string22 = string19;
                String string23 = this.getCorrelationId();
                resetPasswordStartApiResult = new ResetPasswordStartApiResult.UnknownError(string23, string20, string22);
            }
        }
        return resetPasswordStartApiResult;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordStartApiResponse$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

