/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers;

import com.microsoft.identity.common.java.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitNewPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInWithContinuationTokenCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitUserAttributesCommandParameters;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthOAuth2Configuration;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordChallengeRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordContinueRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordPollCompletionRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordStartRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.resetpassword.ResetPasswordSubmitRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInChallengeRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInInitiateRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signin.SignInTokenRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signup.SignUpChallengeRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signup.SignUpContinueRequest;
import com.microsoft.identity.common.java.nativeauth.providers.requests.signup.SignUpStartRequest;
import com.microsoft.identity.common.java.platform.Device;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u001d\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J\u001d\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b)J\u0015\u0010*\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J\u0015\u0010.\u001a\u00020/2\u0006\u0010\u0015\u001a\u000200H\u0000\u00a2\u0006\u0002\b1J\u001d\u00102\u001a\u0002032\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u0002062\u0006\u0010\u0015\u001a\u000207H\u0000\u00a2\u0006\u0002\b8J\u001d\u00109\u001a\u00020:2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b;J\u0015\u0010<\u001a\u00020=2\u0006\u0010\u0015\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?J\u0015\u0010@\u001a\u00020A2\u0006\u0010\u0015\u001a\u00020BH\u0000\u00a2\u0006\u0002\bCJ\u0015\u0010D\u001a\u00020A2\u0006\u0010\u0015\u001a\u00020EH\u0000\u00a2\u0006\u0002\bFJ\u0015\u0010G\u001a\u00020A2\u0006\u0010\u0015\u001a\u00020HH\u0000\u00a2\u0006\u0002\bIJ\u001e\u0010J\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060K2\u0006\u0010!\u001a\u00020\u0006H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthRequestProvider;", "", "config", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Configuration;", "(Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Configuration;)V", "TAG", "", "kotlin.jvm.PlatformType", "resetPasswordChallengeEndpoint", "resetPasswordContinueEndpoint", "resetPasswordPollCompletionEndpoint", "resetPasswordStartEndpoint", "resetPasswordSubmitEndpoint", "signInChallengeEndpoint", "signInInitiateEndpoint", "signInTokenEndpoint", "signUpChallengeEndpoint", "signUpContinueEndpoint", "signUpStartEndpoint", "createContinuationTokenTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInTokenRequest;", "commandParameters", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInWithContinuationTokenCommandParameters;", "createContinuationTokenTokenRequest$common4j", "createOOBTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitCodeCommandParameters;", "createOOBTokenRequest$common4j", "createPasswordTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitPasswordCommandParameters;", "createPasswordTokenRequest$common4j", "createResetPasswordChallengeRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordChallengeRequest;", "continuationToken", "correlationId", "createResetPasswordChallengeRequest$common4j", "createResetPasswordContinueRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordContinueRequest;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitCodeCommandParameters;", "createResetPasswordContinueRequest$common4j", "createResetPasswordPollCompletionRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordPollCompletionRequest;", "createResetPasswordPollCompletionRequest$common4j", "createResetPasswordStartRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordStartRequest;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordStartCommandParameters;", "createResetPasswordStartRequest$common4j", "createResetPasswordSubmitRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/resetpassword/ResetPasswordSubmitRequest;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitNewPasswordCommandParameters;", "createResetPasswordSubmitRequest$common4j", "createSignInChallengeRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInChallengeRequest;", "createSignInChallengeRequest$common4j", "createSignInInitiateRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signin/SignInInitiateRequest;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInStartCommandParameters;", "createSignInInitiateRequest$common4j", "createSignUpChallengeRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signup/SignUpChallengeRequest;", "createSignUpChallengeRequest$common4j", "createSignUpStartRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signup/SignUpStartRequest;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpStartCommandParameters;", "createSignUpStartRequest$common4j", "createSignUpSubmitCodeRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/requests/signup/SignUpContinueRequest;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitCodeCommandParameters;", "createSignUpSubmitCodeRequest$common4j", "createSignUpSubmitPasswordRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitPasswordCommandParameters;", "createSignUpSubmitPasswordRequest$common4j", "createSignUpSubmitUserAttributesRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitUserAttributesCommandParameters;", "createSignUpSubmitUserAttributesRequest$common4j", "getRequestHeaders", "", "common4j"})
public final class NativeAuthRequestProvider {
    @NotNull
    private final NativeAuthOAuth2Configuration config;
    private final String TAG;
    @NotNull
    private final String signUpStartEndpoint;
    @NotNull
    private final String signUpChallengeEndpoint;
    @NotNull
    private final String signUpContinueEndpoint;
    @NotNull
    private final String signInInitiateEndpoint;
    @NotNull
    private final String signInChallengeEndpoint;
    @NotNull
    private final String signInTokenEndpoint;
    @NotNull
    private final String resetPasswordStartEndpoint;
    @NotNull
    private final String resetPasswordChallengeEndpoint;
    @NotNull
    private final String resetPasswordContinueEndpoint;
    @NotNull
    private final String resetPasswordSubmitEndpoint;
    @NotNull
    private final String resetPasswordPollCompletionEndpoint;

    public NativeAuthRequestProvider(@NotNull NativeAuthOAuth2Configuration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.TAG = NativeAuthRequestProvider.class.getSimpleName();
        String string = this.config.getSignUpStartEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.getSignUpStartEndpoint().toString()");
        this.signUpStartEndpoint = string;
        String string2 = this.config.getSignUpChallengeEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.getSignUpChallengeEndpoint().toString()");
        this.signUpChallengeEndpoint = string2;
        String string3 = this.config.getSignUpContinueEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"config.getSignUpContinueEndpoint().toString()");
        this.signUpContinueEndpoint = string3;
        String string4 = this.config.getSignInInitiateEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"config.getSignInInitiateEndpoint().toString()");
        this.signInInitiateEndpoint = string4;
        String string5 = this.config.getSignInChallengeEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"config.getSignInChallengeEndpoint().toString()");
        this.signInChallengeEndpoint = string5;
        String string6 = this.config.getSignInTokenEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"config.getSignInTokenEndpoint().toString()");
        this.signInTokenEndpoint = string6;
        String string7 = this.config.getResetPasswordStartEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"config.getResetPasswordStartEndpoint().toString()");
        this.resetPasswordStartEndpoint = string7;
        String string8 = this.config.getResetPasswordChallengeEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"config.getResetPasswordC\u2026engeEndpoint().toString()");
        this.resetPasswordChallengeEndpoint = string8;
        String string9 = this.config.getResetPasswordContinueEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"config.getResetPasswordC\u2026inueEndpoint().toString()");
        this.resetPasswordContinueEndpoint = string9;
        String string10 = this.config.getResetPasswordSubmitEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"config.getResetPasswordSubmitEndpoint().toString()");
        this.resetPasswordSubmitEndpoint = string10;
        String string11 = this.config.getResetPasswordPollCompletionEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"config.getResetPasswordP\u2026tionEndpoint().toString()");
        this.resetPasswordPollCompletionEndpoint = string11;
    }

    @NotNull
    public final SignInInitiateRequest createSignInInitiateRequest$common4j(@NotNull SignInStartCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, commandParameters.getCorrelationId(), this.TAG + ".createSignInInitiateRequest");
        String string2 = commandParameters.username;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"commandParameters.username");
        String string3 = this.config.getClientId();
        String string4 = this.config.getChallengeType();
        String string5 = commandParameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"commandParameters.getCorrelationId()");
        return SignInInitiateRequest.Companion.create(string2, string3, string4, this.signInInitiateEndpoint, this.getRequestHeaders(string5));
    }

    @NotNull
    public final SignInChallengeRequest createSignInChallengeRequest$common4j(@NotNull String continuationToken, @NotNull String correlationId) {
        Intrinsics.checkNotNullParameter((Object)continuationToken, (String)"continuationToken");
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, correlationId, this.TAG + ".createSignInChallengeRequest");
        return SignInChallengeRequest.Companion.create(this.config.getClientId(), continuationToken, this.config.getChallengeType(), this.signInChallengeEndpoint, this.getRequestHeaders(correlationId));
    }

    @NotNull
    public final SignInTokenRequest createOOBTokenRequest$common4j(@NotNull SignInSubmitCodeCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, commandParameters.getCorrelationId(), this.TAG + ".createOOBTokenRequest");
        SignInTokenRequest.Companion companion = SignInTokenRequest.Companion;
        String string2 = commandParameters.code;
        List list = commandParameters.scopes;
        String string3 = commandParameters.continuationToken;
        String string4 = this.config.getClientId();
        String string5 = this.config.getChallengeType();
        String string6 = this.signInTokenEndpoint;
        String string7 = commandParameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"commandParameters.getCorrelationId()");
        Map<String, String> map = this.getRequestHeaders(string7);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"code");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"continuationToken");
        return companion.createOOBTokenRequest(string2, string3, string4, list, string5, string6, map);
    }

    @NotNull
    public final SignInTokenRequest createContinuationTokenTokenRequest$common4j(@NotNull SignInWithContinuationTokenCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, commandParameters.getCorrelationId(), this.TAG + ".createContinuationTokenRequest");
        SignInTokenRequest.Companion companion = SignInTokenRequest.Companion;
        String string2 = commandParameters.continuationToken;
        List list = commandParameters.scopes;
        String string3 = this.config.getClientId();
        String string4 = commandParameters.username;
        String string5 = this.config.getChallengeType();
        String string6 = this.signInTokenEndpoint;
        String string7 = commandParameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"commandParameters.getCorrelationId()");
        Map<String, String> map = this.getRequestHeaders(string7);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"continuationToken");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"username");
        return companion.createContinuationTokenRequest(string2, string3, string4, list, string5, string6, map);
    }

    @NotNull
    public final SignInTokenRequest createPasswordTokenRequest$common4j(@NotNull SignInSubmitPasswordCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, commandParameters.getCorrelationId(), this.TAG + ".createPasswordTokenRequest");
        SignInTokenRequest.Companion companion = SignInTokenRequest.Companion;
        char[] cArray = commandParameters.password;
        List list = commandParameters.scopes;
        String string2 = commandParameters.continuationToken;
        String string3 = this.config.getClientId();
        String string4 = this.config.getChallengeType();
        String string5 = this.signInTokenEndpoint;
        String string6 = commandParameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"commandParameters.getCorrelationId()");
        Map<String, String> map = this.getRequestHeaders(string6);
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"password");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"continuationToken");
        return companion.createPasswordTokenRequest(cArray, string2, string3, list, string4, string5, map);
    }

    @NotNull
    public final ResetPasswordStartRequest createResetPasswordStartRequest$common4j(@NotNull ResetPasswordStartCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, commandParameters.getCorrelationId(), this.TAG + ".createResetPasswordStartRequest");
        String string2 = this.config.getClientId();
        String string3 = commandParameters.username;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commandParameters.username");
        String string4 = this.config.getChallengeType();
        String string5 = commandParameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"commandParameters.getCorrelationId()");
        return ResetPasswordStartRequest.Companion.create(string2, string3, string4, this.resetPasswordStartEndpoint, this.getRequestHeaders(string5));
    }

    @NotNull
    public final ResetPasswordChallengeRequest createResetPasswordChallengeRequest$common4j(@NotNull String continuationToken, @NotNull String correlationId) {
        Intrinsics.checkNotNullParameter((Object)continuationToken, (String)"continuationToken");
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, correlationId, this.TAG + ".createResetPasswordChallengeRequest");
        return ResetPasswordChallengeRequest.Companion.create(this.config.getClientId(), continuationToken, this.config.getChallengeType(), this.resetPasswordChallengeEndpoint, this.getRequestHeaders(correlationId));
    }

    @NotNull
    public final ResetPasswordContinueRequest createResetPasswordContinueRequest$common4j(@NotNull ResetPasswordSubmitCodeCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, commandParameters.getCorrelationId(), this.TAG + ".createResetPasswordContinueRequest");
        String string2 = this.config.getClientId();
        String string3 = commandParameters.continuationToken;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commandParameters.continuationToken");
        String string4 = commandParameters.code;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"commandParameters.code");
        String string5 = commandParameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"commandParameters.getCorrelationId()");
        return ResetPasswordContinueRequest.Companion.create(string2, string3, string4, this.resetPasswordContinueEndpoint, this.getRequestHeaders(string5));
    }

    @NotNull
    public final SignUpStartRequest createSignUpStartRequest$common4j(@NotNull SignUpStartCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, commandParameters.getCorrelationId(), this.TAG + ".createSignUpStartRequest");
        SignUpStartRequest.Companion companion = SignUpStartRequest.Companion;
        String string2 = commandParameters.username;
        char[] cArray = commandParameters.password;
        Map<String, String> map = commandParameters.userAttributes;
        String string3 = this.config.getChallengeType();
        String string4 = this.config.getClientId();
        String string5 = this.signUpStartEndpoint;
        String string6 = commandParameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"commandParameters.getCorrelationId()");
        Map<String, String> map2 = this.getRequestHeaders(string6);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"username");
        return companion.create(string2, cArray, map, string4, string3, string5, map2);
    }

    @NotNull
    public final ResetPasswordSubmitRequest createResetPasswordSubmitRequest$common4j(@NotNull ResetPasswordSubmitNewPasswordCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, commandParameters.getCorrelationId(), this.TAG + ".createResetPasswordSubmitRequest");
        String string2 = this.config.getClientId();
        String string3 = commandParameters.continuationToken;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commandParameters.continuationToken");
        Intrinsics.checkNotNullExpressionValue((Object)commandParameters.newPassword, (String)"commandParameters.newPassword");
        String string4 = commandParameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"commandParameters.getCorrelationId()");
        return ResetPasswordSubmitRequest.Companion.create(string2, string3, commandParameters.newPassword, this.resetPasswordSubmitEndpoint, this.getRequestHeaders(string4));
    }

    @NotNull
    public final ResetPasswordPollCompletionRequest createResetPasswordPollCompletionRequest$common4j(@NotNull String continuationToken, @NotNull String correlationId) {
        Intrinsics.checkNotNullParameter((Object)continuationToken, (String)"continuationToken");
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, correlationId, this.TAG + ".createResetPasswordPollCompletionRequest");
        return ResetPasswordPollCompletionRequest.Companion.create(this.config.getClientId(), continuationToken, this.resetPasswordPollCompletionEndpoint, this.getRequestHeaders(correlationId));
    }

    @NotNull
    public final SignUpContinueRequest createSignUpSubmitCodeRequest$common4j(@NotNull SignUpSubmitCodeCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, commandParameters.getCorrelationId(), this.TAG + ".createSignUpSubmitCodeRequest");
        String string2 = commandParameters.code;
        String string3 = this.config.getClientId();
        String string4 = commandParameters.continuationToken;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"commandParameters.continuationToken");
        String string5 = commandParameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"commandParameters.getCorrelationId()");
        return SignUpContinueRequest.Companion.create$default(SignUpContinueRequest.Companion, null, null, string2, string3, string4, "oob", this.signUpContinueEndpoint, this.getRequestHeaders(string5), 3, null);
    }

    @NotNull
    public final SignUpContinueRequest createSignUpSubmitPasswordRequest$common4j(@NotNull SignUpSubmitPasswordCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, commandParameters.getCorrelationId(), this.TAG + ".createSignUpSubmitPasswordRequest");
        char[] cArray = commandParameters.password;
        String string2 = this.config.getClientId();
        String string3 = commandParameters.continuationToken;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commandParameters.continuationToken");
        String string4 = commandParameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"commandParameters.getCorrelationId()");
        return SignUpContinueRequest.Companion.create$default(SignUpContinueRequest.Companion, cArray, null, null, string2, string3, "password", this.signUpContinueEndpoint, this.getRequestHeaders(string4), 6, null);
    }

    @NotNull
    public final SignUpContinueRequest createSignUpSubmitUserAttributesRequest$common4j(@NotNull SignUpSubmitUserAttributesCommandParameters commandParameters) {
        Intrinsics.checkNotNullParameter((Object)commandParameters, (String)"commandParameters");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, commandParameters.getCorrelationId(), this.TAG + ".createSignUpSubmitUserAttributesRequest");
        Map<String, String> map = commandParameters.userAttributes;
        String string2 = this.config.getClientId();
        String string3 = commandParameters.continuationToken;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commandParameters.continuationToken");
        String string4 = commandParameters.getCorrelationId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"commandParameters.getCorrelationId()");
        return SignUpContinueRequest.Companion.create$default(SignUpContinueRequest.Companion, null, map, null, string2, string3, "attributes", this.signUpContinueEndpoint, this.getRequestHeaders(string4), 5, null);
    }

    @NotNull
    public final SignUpChallengeRequest createSignUpChallengeRequest$common4j(@NotNull String continuationToken, @NotNull String correlationId) {
        Intrinsics.checkNotNullParameter((Object)continuationToken, (String)"continuationToken");
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, correlationId, this.TAG + ".createSignUpChallengeRequest");
        return SignUpChallengeRequest.Companion.create(continuationToken, this.config.getClientId(), this.config.getChallengeType(), this.signUpChallengeEndpoint, this.getRequestHeaders(correlationId));
    }

    private final Map<String, String> getRequestHeaders(String correlationId) {
        Map headers = new TreeMap();
        headers.put("client-request-id", correlationId);
        headers.put("x-client-SKU", DiagnosticContext.INSTANCE.getRequestContext().get("x-client-SKU"));
        headers.put("x-client-Ver", Device.getProductVersion());
        Map<String, String> map = Device.getPlatformIdParameters();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getPlatformIdParameters()");
        headers.putAll(map);
        Map<String, String> map2 = EstsTelemetry.getInstance().getTelemetryHeaders();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getInstance().telemetryHeaders");
        headers.putAll(map2);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return headers;
    }
}

