/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.interfaces;

import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IHttpClientWrapper;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.interfaces.IPopManagerSupplier;
import com.microsoft.identity.common.java.interfaces.IStorageSupplier;
import com.microsoft.identity.common.java.providers.oauth2.IStateGenerator;
import com.microsoft.identity.common.java.strategies.IAuthorizationStrategyFactory;
import com.microsoft.identity.common.java.util.IBroadcaster;
import com.microsoft.identity.common.java.util.IClockSkewManager;
import com.microsoft.identity.common.java.util.IPlatformUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import lombok.NonNull;

public class PlatformComponents
implements IPlatformComponents {
    @NonNull
    private final IClockSkewManager mClockSkewManager;
    @NonNull
    private final IBroadcaster mBroadcaster;
    @NonNull
    private final IPopManagerSupplier mPopManagerLoader;
    @NonNull
    private final IStorageSupplier mStorageSupplier;
    @Nullable
    private final IAuthorizationStrategyFactory mAuthorizationStrategyFactory;
    @Nullable
    private final IStateGenerator mStateGenerator;
    @NonNull
    private final IPlatformUtil mPlatformUtil;
    @NonNull
    private final IHttpClientWrapper mHttpClientWrapper;

    @Override
    @NonNull
    public IDevicePopManager getDefaultDevicePopManager() throws ClientException {
        return this.mPopManagerLoader.getDefaultDevicePopManager();
    }

    @Override
    @NonNull
    public IDevicePopManager getDevicePopManager(@Nullable String alias) throws ClientException {
        return this.mPopManagerLoader.getDevicePopManager(alias);
    }

    protected PlatformComponents(PlatformComponentsBuilder<?, ?> b) {
        this.mClockSkewManager = ((PlatformComponentsBuilder)b).clockSkewManager;
        if (this.mClockSkewManager == null) {
            throw new NullPointerException("mClockSkewManager is marked non-null but is null");
        }
        this.mBroadcaster = ((PlatformComponentsBuilder)b).broadcaster;
        if (this.mBroadcaster == null) {
            throw new NullPointerException("mBroadcaster is marked non-null but is null");
        }
        this.mPopManagerLoader = ((PlatformComponentsBuilder)b).popManagerLoader;
        if (this.mPopManagerLoader == null) {
            throw new NullPointerException("mPopManagerLoader is marked non-null but is null");
        }
        this.mStorageSupplier = ((PlatformComponentsBuilder)b).storageSupplier;
        if (this.mStorageSupplier == null) {
            throw new NullPointerException("mStorageSupplier is marked non-null but is null");
        }
        this.mAuthorizationStrategyFactory = ((PlatformComponentsBuilder)b).authorizationStrategyFactory;
        this.mStateGenerator = ((PlatformComponentsBuilder)b).stateGenerator;
        this.mPlatformUtil = ((PlatformComponentsBuilder)b).platformUtil;
        if (this.mPlatformUtil == null) {
            throw new NullPointerException("mPlatformUtil is marked non-null but is null");
        }
        this.mHttpClientWrapper = ((PlatformComponentsBuilder)b).httpClientWrapper;
        if (this.mHttpClientWrapper == null) {
            throw new NullPointerException("mHttpClientWrapper is marked non-null but is null");
        }
    }

    public static PlatformComponentsBuilder<?, ?> builder() {
        return new PlatformComponentsBuilderImpl();
    }

    @Override
    @NonNull
    public IClockSkewManager getClockSkewManager() {
        return this.mClockSkewManager;
    }

    @Override
    @NonNull
    public IBroadcaster getBroadcaster() {
        return this.mBroadcaster;
    }

    @NonNull
    public IPopManagerSupplier getPopManagerLoader() {
        return this.mPopManagerLoader;
    }

    @Override
    @NonNull
    public IStorageSupplier getStorageSupplier() {
        return this.mStorageSupplier;
    }

    @Override
    @Nullable
    public IAuthorizationStrategyFactory getAuthorizationStrategyFactory() {
        return this.mAuthorizationStrategyFactory;
    }

    @Override
    @Nullable
    public IStateGenerator getStateGenerator() {
        return this.mStateGenerator;
    }

    @Override
    @NonNull
    public IPlatformUtil getPlatformUtil() {
        return this.mPlatformUtil;
    }

    @Override
    @NonNull
    public IHttpClientWrapper getHttpClientWrapper() {
        return this.mHttpClientWrapper;
    }

    private static final class PlatformComponentsBuilderImpl
    extends PlatformComponentsBuilder<PlatformComponents, PlatformComponentsBuilderImpl> {
        private PlatformComponentsBuilderImpl() {
        }

        @Override
        protected PlatformComponentsBuilderImpl self() {
            return this;
        }

        @Override
        public PlatformComponents build() {
            return new PlatformComponents(this);
        }
    }

    public static abstract class PlatformComponentsBuilder<C extends PlatformComponents, B extends PlatformComponentsBuilder<C, B>> {
        private IClockSkewManager clockSkewManager;
        private IBroadcaster broadcaster;
        private IPopManagerSupplier popManagerLoader;
        private IStorageSupplier storageSupplier;
        private IAuthorizationStrategyFactory authorizationStrategyFactory;
        private IStateGenerator stateGenerator;
        private IPlatformUtil platformUtil;
        private IHttpClientWrapper httpClientWrapper;

        protected abstract B self();

        public abstract C build();

        public B clockSkewManager(@NonNull IClockSkewManager clockSkewManager) {
            if (clockSkewManager == null) {
                throw new NullPointerException("clockSkewManager is marked non-null but is null");
            }
            this.clockSkewManager = clockSkewManager;
            return this.self();
        }

        public B broadcaster(@NonNull IBroadcaster broadcaster) {
            if (broadcaster == null) {
                throw new NullPointerException("broadcaster is marked non-null but is null");
            }
            this.broadcaster = broadcaster;
            return this.self();
        }

        public B popManagerLoader(@NonNull IPopManagerSupplier popManagerLoader) {
            if (popManagerLoader == null) {
                throw new NullPointerException("popManagerLoader is marked non-null but is null");
            }
            this.popManagerLoader = popManagerLoader;
            return this.self();
        }

        public B storageSupplier(@NonNull IStorageSupplier storageSupplier) {
            if (storageSupplier == null) {
                throw new NullPointerException("storageSupplier is marked non-null but is null");
            }
            this.storageSupplier = storageSupplier;
            return this.self();
        }

        public B authorizationStrategyFactory(@Nullable IAuthorizationStrategyFactory authorizationStrategyFactory) {
            this.authorizationStrategyFactory = authorizationStrategyFactory;
            return this.self();
        }

        public B stateGenerator(@Nullable IStateGenerator stateGenerator) {
            this.stateGenerator = stateGenerator;
            return this.self();
        }

        public B platformUtil(@NonNull IPlatformUtil platformUtil) {
            if (platformUtil == null) {
                throw new NullPointerException("platformUtil is marked non-null but is null");
            }
            this.platformUtil = platformUtil;
            return this.self();
        }

        public B httpClientWrapper(@NonNull IHttpClientWrapper httpClientWrapper) {
            if (httpClientWrapper == null) {
                throw new NullPointerException("httpClientWrapper is marked non-null but is null");
            }
            this.httpClientWrapper = httpClientWrapper;
            return this.self();
        }

        public String toString() {
            return "PlatformComponents.PlatformComponentsBuilder(clockSkewManager=" + this.clockSkewManager + ", broadcaster=" + this.broadcaster + ", popManagerLoader=" + this.popManagerLoader + ", storageSupplier=" + this.storageSupplier + ", authorizationStrategyFactory=" + this.authorizationStrategyFactory + ", stateGenerator=" + this.stateGenerator + ", platformUtil=" + this.platformUtil + ", httpClientWrapper=" + this.httpClientWrapper + ")";
        }
    }
}

