/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.eststelemetry;

import com.microsoft.identity.common.java.eststelemetry.ICurrentTelemetry;
import com.microsoft.identity.common.java.eststelemetry.RequestTelemetry;
import com.microsoft.identity.common.java.eststelemetry.TelemetryUtils;
import lombok.NonNull;

class CurrentRequestTelemetry
extends RequestTelemetry
implements ICurrentTelemetry {
    private String mApiId;
    private boolean mForceRefresh;

    CurrentRequestTelemetry() {
        super("2");
    }

    @Override
    public String getHeaderStringForFields() {
        return TelemetryUtils.getSchemaCompliantString(this.mApiId) + "," + TelemetryUtils.getSchemaCompliantStringFromBoolean(this.mForceRefresh);
    }

    @Override
    public void put(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        switch (key) {
            case "Microsoft.MSAL.api_id": {
                this.mApiId = value;
                break;
            }
            case "Microsoft.MSAL.force_refresh": {
                this.mForceRefresh = TelemetryUtils.getBooleanFromString(value);
                break;
            }
            default: {
                this.putInPlatformTelemetry(key, value);
            }
        }
    }

    public String getApiId() {
        return this.mApiId;
    }

    public boolean isForceRefresh() {
        return this.mForceRefresh;
    }
}

