/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto.key;

import com.microsoft.identity.common.java.crypto.key.AES256KeyLoader;
import javax.crypto.SecretKey;
import lombok.NonNull;

public class PredefinedKeyLoader
extends AES256KeyLoader {
    public static final String USER_PROVIDED_KEY_IDENTIFIER = "U001";
    private final String mAlias;
    private final SecretKey mKey;

    public PredefinedKeyLoader(@NonNull String alias, @NonNull byte[] rawBytes) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        if (rawBytes == null) {
            throw new NullPointerException("rawBytes is marked non-null but is null");
        }
        this.mAlias = alias;
        this.mKey = this.generateKeyFromRawBytes(rawBytes);
    }

    @Override
    @NonNull
    public String getAlias() {
        return this.mAlias;
    }

    @Override
    @NonNull
    public SecretKey getKey() {
        return this.mKey;
    }

    @Override
    @NonNull
    public String getKeyTypeIdentifier() {
        return USER_PROVIDED_KEY_IDENTIFIER;
    }
}

