/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto.key;

import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import cz.msebera.android.httpclient.extras.Base64;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

public abstract class AbstractSecretKeyLoader {
    private static final String TAG = AbstractSecretKeyLoader.class.getSimpleName();

    @NonNull
    public abstract String getAlias();

    @NonNull
    public abstract SecretKey getKey() throws ClientException;

    @NonNull
    protected abstract String getKeySpecAlgorithm();

    protected abstract int getKeySize();

    @NonNull
    public abstract String getKeyTypeIdentifier();

    @NonNull
    public abstract String getCipherAlgorithm();

    @NonNull
    protected SecretKey generateRandomKey() throws ClientException {
        String methodName = ":generateRandomKey";
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(this.getKeySpecAlgorithm());
            keygen.init(this.getKeySize(), new SecureRandom());
            return keygen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            ClientException clientException = new ClientException("no_such_algorithm", e.getMessage(), e);
            Logger.error(TAG + ":generateRandomKey", clientException.getErrorCode(), e);
            throw clientException;
        }
    }

    @NonNull
    protected SecretKey generateKeyFromRawBytes(@NonNull byte[] rawBytes) {
        if (rawBytes == null) {
            throw new NullPointerException("rawBytes is marked non-null but is null");
        }
        return new SecretKeySpec(rawBytes, this.getKeySpecAlgorithm());
    }

    public String serializeSecretKey(@NonNull SecretKey key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Base64.encodeToString((byte[])key.getEncoded(), (int)0);
    }

    public SecretKey deserializeSecretKey(@NonNull String serializedKey) {
        if (serializedKey == null) {
            throw new NullPointerException("serializedKey is marked non-null but is null");
        }
        return this.generateKeyFromRawBytes(Base64.decode((String)serializedKey, (int)0));
    }
}

