/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.crypto.CryptoSuite;
import com.microsoft.identity.common.java.crypto.DefaultCryptoFactory;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.crypto.SP800108KeyGen;
import com.microsoft.identity.common.java.crypto.SecureHardwareState;
import com.microsoft.identity.common.java.exception.ClientException;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class RawKeyAccessor
implements IKeyAccessor {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    @NonNull
    private final CryptoSuite mSuite;
    @NonNull
    private final byte[] mKey;
    private final String mAlias;

    public byte[] getRawKey() {
        return Arrays.copyOf(this.mKey, this.mKey.length);
    }

    @Override
    public byte[] encrypt(@NonNull byte[] plaintext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (plaintext == null) {
            throw new NullPointerException("plaintext is marked non-null but is null");
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(this.mKey, this.mSuite.cipher().name());
            Cipher c = Cipher.getInstance(keySpec.getAlgorithm());
            byte[] iv = new byte[12];
            SECURE_RANDOM.nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            c.init(1, (Key)keySpec, ivSpec);
            byte[] text = c.update(plaintext);
            byte[] tmp = c.doFinal();
            byte[] output = new byte[iv.length + text.length + tmp.length];
            System.arraycopy(iv, 0, output, 0, iv.length);
            System.arraycopy(text, 0, output, iv.length, text.length);
            System.arraycopy(tmp, 0, output, iv.length + text.length, tmp.length);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage());
    }

    @Override
    public byte[] decrypt(@NonNull byte[] ciphertext) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (ciphertext == null) {
            throw new NullPointerException("ciphertext is marked non-null but is null");
        }
        try {
            SecretKeySpec key = new SecretKeySpec(this.mKey, this.mSuite.cipher().name());
            Cipher c = Cipher.getInstance(key.getAlgorithm());
            IvParameterSpec ivSpec = new IvParameterSpec(ciphertext, 0, 12);
            c.init(2, (Key)key, ivSpec);
            byte[] out = Arrays.copyOfRange(ciphertext, 12, ciphertext.length);
            return c.doFinal(out);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        catch (InvalidAlgorithmParameterException e) {
            errCode = "invalid_algorithm_parameter";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    @Override
    public byte[] sign(@NonNull byte[] text) throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        try {
            SecretKeySpec key = new SecretKeySpec(this.mKey, this.mSuite.cipher().name());
            Mac mac = Mac.getInstance(this.mSuite.macName());
            mac.init(key);
            return mac.doFinal(text);
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (InvalidKeyException e) {
            errCode = "invalid_key";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage());
    }

    @Override
    public boolean verify(@NonNull byte[] text, @NonNull byte[] signature) throws ClientException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        return Arrays.equals(signature, this.sign(text));
    }

    @Override
    public byte[] getThumbprint() throws ClientException {
        GeneralSecurityException exception;
        String errCode;
        SecretKeySpec keySpec = new SecretKeySpec(this.mKey, this.mSuite.cipher().name());
        try {
            Cipher cipher = Cipher.getInstance(keySpec.getAlgorithm());
            MessageDigest digest = MessageDigest.getInstance("SHA256");
            return digest.digest(cipher.doFinal((keySpec.getAlgorithm() + cipher.getBlockSize() + cipher.getParameters()).getBytes(AuthenticationConstants.CHARSET_UTF8)));
        }
        catch (NoSuchAlgorithmException e) {
            errCode = "no_such_algorithm";
            exception = e;
        }
        catch (NoSuchPaddingException e) {
            errCode = "no_such_padding";
            exception = e;
        }
        catch (BadPaddingException e) {
            errCode = "bad_padding";
            exception = e;
        }
        catch (IllegalBlockSizeException e) {
            errCode = "invalid_block_size";
            exception = e;
        }
        throw new ClientException(errCode, exception.getMessage(), exception);
    }

    @Override
    @Nullable
    public Certificate[] getCertificateChain() {
        return null;
    }

    @Override
    public SecureHardwareState getSecureHardwareState() {
        return SecureHardwareState.FALSE;
    }

    public byte[] generateDerivedKey(byte[] label, @NonNull byte[] ctx) throws ClientException {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        try {
            return new SP800108KeyGen(new DefaultCryptoFactory()).generateDerivedKey(this.mKey, label, ctx);
        }
        catch (IOException e) {
            throw new ClientException("io_error", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("no_such_algorithm", e.getMessage(), e);
        }
    }

    @Override
    public IKeyAccessor generateDerivedKey(@NonNull byte[] label, @NonNull byte[] ctx, @NonNull CryptoSuite suite) throws ClientException {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (suite == null) {
            throw new NullPointerException("suite is marked non-null but is null");
        }
        try {
            return new RawKeyAccessor(suite, new SP800108KeyGen(new DefaultCryptoFactory()).generateDerivedKey(this.mKey, label, ctx), null);
        }
        catch (IOException e) {
            throw new ClientException("io_error", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("no_such_algorithm", e.getMessage(), e);
        }
    }

    public static RawKeyAccessorBuilder builder() {
        return new RawKeyAccessorBuilder();
    }

    @NonNull
    public CryptoSuite getSuite() {
        return this.mSuite;
    }

    @NonNull
    public byte[] getKey() {
        return this.mKey;
    }

    public String getAlias() {
        return this.mAlias;
    }

    public RawKeyAccessor(@NonNull CryptoSuite suite, @NonNull byte[] key, String alias) {
        if (suite == null) {
            throw new NullPointerException("suite is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.mSuite = suite;
        this.mKey = key;
        this.mAlias = alias;
    }

    public static class RawKeyAccessorBuilder {
        private CryptoSuite suite;
        private byte[] key;
        private String alias;

        RawKeyAccessorBuilder() {
        }

        public RawKeyAccessorBuilder suite(@NonNull CryptoSuite suite) {
            if (suite == null) {
                throw new NullPointerException("suite is marked non-null but is null");
            }
            this.suite = suite;
            return this;
        }

        public RawKeyAccessorBuilder key(@NonNull byte[] key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
            return this;
        }

        public RawKeyAccessorBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public RawKeyAccessor build() {
            return new RawKeyAccessor(this.suite, this.key, this.alias);
        }

        public String toString() {
            return "RawKeyAccessor.RawKeyAccessorBuilder(suite=" + this.suite + ", key=" + Arrays.toString(this.key) + ", alias=" + this.alias + ")";
        }
    }
}

