/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.crypto.IKeyAccessorStringAdapter;
import com.microsoft.identity.common.java.exception.ClientException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/microsoft/identity/common/java/crypto/KeyAccessorStringAdapter;", "Lcom/microsoft/identity/common/java/crypto/IKeyAccessorStringAdapter;", "mKeyAccessor", "Lcom/microsoft/identity/common/java/crypto/IKeyAccessor;", "(Lcom/microsoft/identity/common/java/crypto/IKeyAccessor;)V", "decrypt", "", "cipherText", "encrypt", "plainText", "common4j"})
public final class KeyAccessorStringAdapter
implements IKeyAccessorStringAdapter {
    @NotNull
    private final IKeyAccessor mKeyAccessor;

    public KeyAccessorStringAdapter(@NotNull IKeyAccessor mKeyAccessor) {
        Intrinsics.checkNotNullParameter((Object)mKeyAccessor, (String)"mKeyAccessor");
        this.mKeyAccessor = mKeyAccessor;
    }

    @Override
    @NotNull
    public String encrypt(@NotNull String plainText) throws ClientException {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Object object = plainText;
        Charset charset = AuthenticationConstants.CHARSET_UTF8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"CHARSET_UTF8");
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] result = this.mKeyAccessor.encrypt(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        object = result;
        Charset charset2 = AuthenticationConstants.CHARSET_UTF8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"CHARSET_UTF8");
        Charset charset3 = charset2;
        return new String((byte[])object, charset3);
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String cipherText) throws ClientException {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Object object = cipherText;
        Charset charset = AuthenticationConstants.CHARSET_UTF8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"CHARSET_UTF8");
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] result = this.mKeyAccessor.decrypt(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        object = result;
        Charset charset2 = AuthenticationConstants.CHARSET_UTF8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"CHARSET_UTF8");
        Charset charset3 = charset2;
        return new String((byte[])object, charset3);
    }
}

