/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.crypto.ICryptoFactory;
import com.microsoft.identity.common.java.crypto.IDecryptor;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.opentelemetry.CryptoFactoryTelemetryHelper;
import com.microsoft.identity.common.java.opentelemetry.CryptoObjectName;
import com.microsoft.identity.common.java.opentelemetry.ICryptoOperation;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import lombok.NonNull;

public class BasicDecryptor
implements IDecryptor {
    private final ICryptoFactory mCryptoFactory;

    @Override
    public byte[] decryptWithIv(final @NonNull Key key, final @NonNull String decryptAlgorithm, final byte[] iv, final byte[] dataToBeDecrypted) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (decryptAlgorithm == null) {
            throw new NullPointerException("decryptAlgorithm is marked non-null but is null");
        }
        return CryptoFactoryTelemetryHelper.performCryptoOperationAndUploadTelemetry(CryptoObjectName.Cipher, decryptAlgorithm, this.mCryptoFactory, new ICryptoOperation<byte[]>(){

            @Override
            public byte[] perform() throws ClientException {
                return BasicDecryptor.this.decryptWithIvInternal(key, decryptAlgorithm, iv, dataToBeDecrypted);
            }
        });
    }

    @Override
    public byte[] decryptWithGcm(final @NonNull Key key, final @NonNull String decryptAlgorithm, final byte[] iv, final byte[] dataToBeDecrypted, final int tagLength, final byte[] aad) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (decryptAlgorithm == null) {
            throw new NullPointerException("decryptAlgorithm is marked non-null but is null");
        }
        return CryptoFactoryTelemetryHelper.performCryptoOperationAndUploadTelemetry(CryptoObjectName.Cipher, decryptAlgorithm, this.mCryptoFactory, new ICryptoOperation<byte[]>(){

            @Override
            public byte[] perform() throws ClientException {
                return BasicDecryptor.this.decryptWithGcmInternal(key, decryptAlgorithm, iv, dataToBeDecrypted, tagLength, aad);
            }
        });
    }

    private byte[] decryptWithIvInternal(@NonNull Key key, @NonNull String decryptAlgorithm, byte[] iv, byte[] dataToBeDecrypted) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (decryptAlgorithm == null) {
            throw new NullPointerException("decryptAlgorithm is marked non-null but is null");
        }
        Cipher cipher = this.mCryptoFactory.getCipher(decryptAlgorithm);
        try {
            if (iv != null && iv.length > 0) {
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher.init(2, key, ivSpec);
            } else {
                cipher.init(2, key);
            }
            return cipher.doFinal(dataToBeDecrypted);
        }
        catch (BadPaddingException e) {
            throw new ClientException("bad_padding", e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ClientException("invalid_block_size", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ClientException("invalid_algorithm_parameter", e.getMessage(), e);
        }
    }

    private byte[] decryptWithGcmInternal(@NonNull Key key, @NonNull String decryptAlgorithm, byte[] iv, byte[] dataToBeDecrypted, int tagLength, @Nullable byte[] aad) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (decryptAlgorithm == null) {
            throw new NullPointerException("decryptAlgorithm is marked non-null but is null");
        }
        Cipher cipher = this.mCryptoFactory.getCipher(decryptAlgorithm);
        try {
            GCMParameterSpec spec = new GCMParameterSpec(tagLength * 8, iv);
            cipher.init(2, key, spec);
            if (aad != null) {
                cipher.updateAAD(aad);
            }
            return cipher.doFinal(dataToBeDecrypted);
        }
        catch (BadPaddingException e) {
            throw new ClientException("bad_padding", e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ClientException("invalid_block_size", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ClientException("invalid_algorithm_parameter", e.getMessage(), e);
        }
    }

    public BasicDecryptor(ICryptoFactory mCryptoFactory) {
        this.mCryptoFactory = mCryptoFactory;
    }
}

