/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands;

import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.TokenCommand;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.controllers.IControllerFactory;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import lombok.NonNull;

public class InteractiveTokenCommand
extends TokenCommand {
    private static final String TAG = InteractiveTokenCommand.class.getSimpleName();
    private BaseController mController;

    public InteractiveTokenCommand(@NonNull InteractiveTokenCommandParameters parameters, @NonNull IControllerFactory controllerFactory, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super(parameters, controllerFactory, callback, publicApiId);
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (controllerFactory == null) {
            throw new NullPointerException("controllerFactory is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AcquireTokenResult execute() throws Exception {
        String methodName = ":execute";
        Span span = SpanExtension.current();
        span.setAttribute(AttributeName.application_name.name(), this.getParameters().getApplicationName());
        span.setAttribute(AttributeName.public_api_id.name(), this.getPublicApiId());
        try (Scope scope = SpanExtension.makeCurrentSpan(span);){
            if (!(this.getParameters() instanceof InteractiveTokenCommandParameters)) throw new IllegalArgumentException("Invalid operation parameters");
            Logger.info(TAG + ":execute", "Executing interactive token command...");
            this.mController = this.getControllerFactory().getDefaultController();
            span.setAttribute(AttributeName.controller_name.name(), this.mController.getClass().getSimpleName());
            AcquireTokenResult result = this.mController.acquireToken((InteractiveTokenCommandParameters)this.getParameters());
            if (result == null) {
                span.setStatus(StatusCode.ERROR, "empty result");
            } else if (result.getSucceeded().booleanValue()) {
                span.setStatus(StatusCode.OK);
            } else {
                BaseException exception = ExceptionAdapter.exceptionFromAcquireTokenResult(result, this.getParameters());
                if (exception != null) {
                    span.recordException((Throwable)exception);
                    span.setStatus(StatusCode.ERROR);
                } else {
                    span.setStatus(StatusCode.ERROR, "empty exception");
                }
            }
            AcquireTokenResult acquireTokenResult = result;
            return acquireTokenResult;
        }
        catch (Throwable throwable) {
            span.setStatus(StatusCode.ERROR);
            span.recordException(throwable);
            throw throwable;
        }
    }

    public void onFinishAuthorizationSession(int requestCode, int resultCode, @NonNull PropertyBag data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.mController.onFinishAuthorizationSession(requestCode, resultCode, data);
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InteractiveTokenCommand)) {
            return false;
        }
        InteractiveTokenCommand other = (InteractiveTokenCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseController this$mController = this.mController;
        BaseController other$mController = other.mController;
        return !(this$mController == null ? other$mController != null : !((Object)this$mController).equals(other$mController));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InteractiveTokenCommand;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BaseController $mController = this.mController;
        result = result * 59 + ($mController == null ? 43 : ((Object)$mController).hashCode());
        return result;
    }
}

