/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands;

import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.TokenCommand;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.controllers.IControllerFactory;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import lombok.NonNull;

public class DeviceCodeFlowTokenResultCommand
extends TokenCommand {
    private static final String TAG = DeviceCodeFlowTokenResultCommand.class.getSimpleName();
    private final AuthorizationResult mAuthorizationResult;

    public DeviceCodeFlowTokenResultCommand(@NonNull DeviceCodeFlowCommandParameters parameters, @NonNull AuthorizationResult authorizationResult, @NonNull IControllerFactory controllerFactory, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super(parameters, controllerFactory, callback, publicApiId);
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (authorizationResult == null) {
            throw new NullPointerException("authorizationResult is marked non-null but is null");
        }
        if (controllerFactory == null) {
            throw new NullPointerException("controllerFactory is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
        this.mAuthorizationResult = authorizationResult;
    }

    @Override
    public AcquireTokenResult execute() throws Exception {
        String methodTag = TAG + ":execute";
        Logger.verbose(methodTag, "DeviceCodeFlowTokenResultCommand initiating...");
        Span span = OTelUtility.createSpanFromParent(SpanName.AcquireTokenDcfFetchToken.name(), this.getParameters().getSpanContext());
        span.setAttribute(AttributeName.application_name.name(), this.getParameters().getApplicationName());
        span.setAttribute(AttributeName.public_api_id.name(), this.getPublicApiId());
        try {
            AcquireTokenResult acquireTokenResult;
            block17: {
                Scope scope = SpanExtension.makeCurrentSpan(span);
                try {
                    BaseController controller = this.getControllerFactory().getDefaultController();
                    DeviceCodeFlowCommandParameters commandParameters = (DeviceCodeFlowCommandParameters)this.getParameters();
                    AcquireTokenResult tokenResult = controller.acquireDeviceCodeFlowToken(this.mAuthorizationResult, commandParameters);
                    if (tokenResult == null) {
                        span.setStatus(StatusCode.ERROR, "empty result");
                    } else if (tokenResult.getSucceeded().booleanValue()) {
                        span.setStatus(StatusCode.OK);
                    } else {
                        BaseException exception = ExceptionAdapter.exceptionFromAcquireTokenResult(tokenResult, this.getParameters());
                        if (exception != null && !exception.getErrorCode().equals("authorization_pending")) {
                            span.recordException((Throwable)exception);
                            span.setStatus(StatusCode.ERROR);
                        } else {
                            span.setStatus(StatusCode.ERROR, "empty exception");
                        }
                    }
                    Logger.verbose(methodTag, "DeviceCodeFlowTokenResultCommand exiting with token...");
                    acquireTokenResult = tokenResult;
                    if (scope == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        span.setStatus(StatusCode.ERROR);
                        span.recordException(throwable3);
                        throw throwable3;
                    }
                }
                scope.close();
            }
            return acquireTokenResult;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }
}

