/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HttpCache {
    private static IHttpCacheCallback sHttpCache;
    private static final ReentrantReadWriteLock sLock;

    public static void setHttpCache(@Nullable IHttpCacheCallback httpCacheCallback) {
        sLock.writeLock().lock();
        try {
            sHttpCache = httpCacheCallback;
        }
        finally {
            sLock.writeLock().unlock();
        }
    }

    public static void flush() {
        sLock.readLock().lock();
        try {
            if (sHttpCache != null) {
                sHttpCache.flush();
            }
        }
        finally {
            sLock.readLock().unlock();
        }
    }

    static {
        sLock = new ReentrantReadWriteLock();
    }

    public static interface IHttpCacheCallback {
        public void flush();
    }
}

