/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.authscheme;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.java.authscheme.TokenAuthenticationScheme;
import com.nimbusds.jose.util.Base64URL;
import java.net.URL;
import lombok.NonNull;
import org.json.JSONObject;

public class PopAuthenticationSchemeWithClientKeyInternal
extends TokenAuthenticationScheme
implements IPoPAuthenticationSchemeParams {
    private static final long serialVersionUID = 788393037295696359L;
    public static final String SCHEME_POP_WITH_CLIENT_KEY = "PoP_With_Client_Key";
    @SerializedName(value="kid")
    private String mKid;

    PopAuthenticationSchemeWithClientKeyInternal() {
        super(SCHEME_POP_WITH_CLIENT_KEY);
    }

    public PopAuthenticationSchemeWithClientKeyInternal(@NonNull String kid) {
        super(SCHEME_POP_WITH_CLIENT_KEY);
        if (kid == null) {
            throw new NullPointerException("kid is marked non-null but is null");
        }
        this.mKid = kid;
    }

    @Override
    public String getAccessTokenForScheme(@NonNull String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        return accessToken;
    }

    public String getKid() {
        return this.mKid;
    }

    public String getRequestConfirmation() {
        String reqCnfJson = new JSONObject().put("kid", (Object)this.mKid).toString();
        return Base64URL.encode((String)reqCnfJson).toString();
    }

    @Override
    public String getNonce() {
        return null;
    }

    @Override
    public String getHttpMethod() {
        return null;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public String getClientClaims() {
        return null;
    }

    protected PopAuthenticationSchemeWithClientKeyInternal(PopAuthenticationSchemeWithClientKeyInternalBuilder<?, ?> b) {
        super((TokenAuthenticationScheme.TokenAuthenticationSchemeBuilder<?, ?>)b);
        this.mKid = ((PopAuthenticationSchemeWithClientKeyInternalBuilder)b).kid;
    }

    public static PopAuthenticationSchemeWithClientKeyInternalBuilder<?, ?> builder() {
        return new PopAuthenticationSchemeWithClientKeyInternalBuilderImpl();
    }

    public PopAuthenticationSchemeWithClientKeyInternalBuilder<?, ?> toBuilder() {
        return new PopAuthenticationSchemeWithClientKeyInternalBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PopAuthenticationSchemeWithClientKeyInternal)) {
            return false;
        }
        PopAuthenticationSchemeWithClientKeyInternal other = (PopAuthenticationSchemeWithClientKeyInternal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mKid = this.getKid();
        String other$mKid = other.getKid();
        return !(this$mKid == null ? other$mKid != null : !this$mKid.equals(other$mKid));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PopAuthenticationSchemeWithClientKeyInternal;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mKid = this.getKid();
        result = result * 59 + ($mKid == null ? 43 : $mKid.hashCode());
        return result;
    }

    private static final class PopAuthenticationSchemeWithClientKeyInternalBuilderImpl
    extends PopAuthenticationSchemeWithClientKeyInternalBuilder<PopAuthenticationSchemeWithClientKeyInternal, PopAuthenticationSchemeWithClientKeyInternalBuilderImpl> {
        private PopAuthenticationSchemeWithClientKeyInternalBuilderImpl() {
        }

        @Override
        protected PopAuthenticationSchemeWithClientKeyInternalBuilderImpl self() {
            return this;
        }

        @Override
        public PopAuthenticationSchemeWithClientKeyInternal build() {
            return new PopAuthenticationSchemeWithClientKeyInternal(this);
        }
    }

    public static abstract class PopAuthenticationSchemeWithClientKeyInternalBuilder<C extends PopAuthenticationSchemeWithClientKeyInternal, B extends PopAuthenticationSchemeWithClientKeyInternalBuilder<C, B>>
    extends TokenAuthenticationScheme.TokenAuthenticationSchemeBuilder<C, B> {
        private String kid;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PopAuthenticationSchemeWithClientKeyInternalBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(PopAuthenticationSchemeWithClientKeyInternal instance, PopAuthenticationSchemeWithClientKeyInternalBuilder<?, ?> b) {
            b.kid(instance.mKid);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B kid(String kid) {
            this.kid = kid;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PopAuthenticationSchemeWithClientKeyInternal.PopAuthenticationSchemeWithClientKeyInternalBuilder(super=" + super.toString() + ", kid=" + this.kid + ")";
        }
    }
}

