/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.adal.cache;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.microsoft.identity.common.java.logging.Logger;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeAdapter
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    private static final String TAG = "DateTimeAdapter";
    private final DateFormat mEnUsFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private final DateFormat mLocalFormat = DateFormat.getDateTimeInstance(2, 2);
    private final DateFormat mISO8601Format = DateTimeAdapter.buildIso8601Format();
    private final DateFormat mEnUs24HourFormat = DateTimeAdapter.buildEnUs24HourDateFormat();
    private final DateFormat mLocal24HourFormat = DateTimeAdapter.buildLocal24HourDateFormat();

    private static DateFormat buildIso8601Format() {
        SimpleDateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        iso8601Format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return iso8601Format;
    }

    private static DateFormat buildEnUs24HourDateFormat() {
        return new SimpleDateFormat("MMM dd, yyyy HH:mm:ss", Locale.US);
    }

    private static DateFormat buildLocal24HourDateFormat() {
        return new SimpleDateFormat("MMM dd, yyyy HH:mm:ss", Locale.getDefault());
    }

    public synchronized Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String jsonString = json.getAsString();
        try {
            return this.mISO8601Format.parse(jsonString);
        }
        catch (ParseException ignored) {
            Logger.verbose(TAG, "Cannot parse with ISO8601, try again with local format.");
            try {
                return this.mLocalFormat.parse(jsonString);
            }
            catch (ParseException ignored2) {
                Logger.verbose(TAG, "Cannot parse with local format, try again with local 24 hour format.");
                try {
                    return this.mLocal24HourFormat.parse(jsonString);
                }
                catch (ParseException ignored3) {
                    Logger.verbose(TAG, "Cannot parse with local 24 hour format, try again with en us format.");
                    try {
                        return this.mEnUsFormat.parse(jsonString);
                    }
                    catch (ParseException ignored4) {
                        Logger.verbose(TAG, "Cannot parse with en us format, try again with en us 24 hour format.");
                        try {
                            return this.mEnUs24HourFormat.parse(jsonString);
                        }
                        catch (ParseException e) {
                            Logger.error(TAG, "Could not parse date: " + e.getMessage(), e);
                            throw new JsonParseException("Could not parse date: " + jsonString);
                        }
                    }
                }
            }
        }
    }

    public synchronized JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.mISO8601Format.format(src));
    }
}

